/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.networking.ext.VpnService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.networking.domain.NeutronVpn;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;

public class VpnServiceImpl
extends BaseNetworkingServices
implements VpnService {
    private static final String API_PATH = "/vpn/vpnservices";
    private static final String filter = "fields";

    @Override
    public NeutronVpn create(NeutronVpn model) {
        return this.post(NeutronVpn.class, this.uri(API_PATH, new Object[0])).entity(model).execute();
    }

    @Override
    public List<NeutronVpn> list(String fields) {
        return this.get(NeutronVpn.NeutronVpns.class, this.uri(API_PATH, new Object[0])).param(filter, fields).execute().getList();
    }

    @Override
    public ActionResponse delete(String serviceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceId) ? 1 : 0) != 0, (Object)"parameter `serviceId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vpn/vpnservices/%s", serviceId)).executeWithResponse());
    }

    @Override
    public NeutronVpn get(String serviceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceId) ? 1 : 0) != 0, (Object)"parameter `serviceId` should not be empty");
        return this.get(NeutronVpn.class, this.uri("/vpn/vpnservices/%s", serviceId)).execute();
    }

    @Override
    public NeutronVpn update(NeutronVpn model, String serviceId) {
        Preconditions.checkArgument((null != model ? 1 : 0) != 0, (Object)"parameter `updateModel` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceId) ? 1 : 0) != 0, (Object)"parameter `serviceId` should not be empty");
        return this.put(NeutronVpn.class, this.uri("/vpn/vpnservices/%s", serviceId)).entity(model).execute();
    }
}

