/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.ext.AgentService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.network.Agent;
import com.huawei.openstack4j.openstack.networking.domain.NeutronAgent;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;

public class AgentServiceImpl
extends BaseNetworkingServices
implements AgentService {
    @Override
    public List<? extends Agent> list() {
        return this.get(NeutronAgent.Agents.class, this.uri("/agents", new Object[0])).execute().getList();
    }

    @Override
    public Agent getAgent(String agentId) {
        Preconditions.checkNotNull((Object)agentId);
        return this.get(NeutronAgent.class, this.uri("/agents/%s", agentId)).execute();
    }

    @Override
    public Agent setAdminStateUp(String agentId, boolean state) {
        Preconditions.checkNotNull((Object)agentId);
        String json = String.format("{\"%s\": { \"%s\": \"%b\"}}", "agent", "admin_state_up", state);
        return this.put(NeutronAgent.class, this.uri("/agents/%s", agentId)).json(json).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

