/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.networking.ext.LbCertificateV2Service;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronCertificate;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronCertificateUpdate;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class LbCertificateV2ServiceImpl
extends BaseNetworkingServices
implements LbCertificateV2Service {
    private static final String API_PATH = "/lbaas/certificates";

    @Override
    public NeutronCertificate get(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"parameter `certificateId` should not be empty");
        return this.get(NeutronCertificate.class, this.uri("/lbaas/certificates/%s", id)).execute();
    }

    @Override
    public NeutronCertificate.NeutronCertificates list() {
        return this.get(NeutronCertificate.NeutronCertificates.class, this.uri(API_PATH, new Object[0])).execute();
    }

    @Override
    public List<? extends NeutronCertificate> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronCertificate.NeutronCertificates> serverInvocation = this.get(NeutronCertificate.NeutronCertificates.class, this.uri(API_PATH, new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                serverInvocation = serverInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return serverInvocation.execute().getList();
    }

    @Override
    public NeutronCertificate create(NeutronCertificate model) {
        Preconditions.checkArgument((null != model ? 1 : 0) != 0, (Object)"parameter `certificateModel` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)model.getPrivateKey()) ? 1 : 0) != 0, (Object)"parameter `privateKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)model.getCertificate()) ? 1 : 0) != 0, (Object)"parameter `certificate` should not be empty");
        return this.post(NeutronCertificate.class, this.uri(API_PATH, new Object[0])).entity(model).execute();
    }

    @Override
    public NeutronCertificate update(NeutronCertificateUpdate model, String id) {
        Preconditions.checkArgument((null != model ? 1 : 0) != 0, (Object)"parameter `updateModel` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"parameter `id` should not be empty");
        return this.put(NeutronCertificate.class, this.uri("/lbaas/certificates/%s", id)).entity(model).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"parameter `certificateId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/certificates/%s", id)).executeWithResponse());
    }
}

