/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.networking.ext.LbRuleV2Service;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronRule;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronRuleUpdate;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class LbRuleV2ServiceImpl
extends BaseNetworkingServices
implements LbRuleV2Service {
    private static final String API_PATH = "/lbaas/l7policies";

    @Override
    public NeutronRule.NeutronRules list(String l7policyId) {
        return this.get(NeutronRule.NeutronRules.class, this.uri("/lbaas/l7policies/%s/rules", l7policyId)).execute();
    }

    @Override
    public List<? extends NeutronRule> list(String l7policyId, Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronRule.NeutronRules> serverInvocation = this.get(NeutronRule.NeutronRules.class, this.uri("/lbaas/l7policies/%s/rules", l7policyId));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                serverInvocation = serverInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return serverInvocation.execute().getList();
    }

    @Override
    public NeutronRule get(String l7policyId, String ruleId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)l7policyId) ? 1 : 0) != 0, (Object)"parameter `policyId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ruleId) ? 1 : 0) != 0, (Object)"parameter `ruleId` should not be empty");
        return this.get(NeutronRule.class, this.uri("/lbaas/l7policies/%s/rules/%s", l7policyId, ruleId)).execute();
    }

    @Override
    public NeutronRule create(NeutronRule ruleModel, String l7policyId) {
        Preconditions.checkArgument((ruleModel != null ? 1 : 0) != 0, (Object)"parameter `ruleModel` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ruleModel.getCompareType()) ? 1 : 0) != 0, (Object)"parameter `compare-type` should not be empty");
        Preconditions.checkArgument((ruleModel.getType() != null ? 1 : 0) != 0, (Object)"parameter `type` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ruleModel.getValue()) ? 1 : 0) != 0, (Object)"parameter `value` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)l7policyId) ? 1 : 0) != 0, (Object)"parameter `l7policyId` should not be empty");
        return this.post(NeutronRule.class, this.uri("/lbaas/l7policies/%s/rules", l7policyId)).entity(ruleModel).execute();
    }

    @Override
    public NeutronRule update(NeutronRuleUpdate updateModel, String l7policyId, String ruleId) {
        Preconditions.checkArgument((updateModel != null ? 1 : 0) != 0, (Object)"parameter `ruleUpdateModel` should not be empty");
        return this.put(NeutronRule.class, this.uri("/lbaas/l7policies/%s/rules/%s", l7policyId, ruleId)).entity(updateModel).execute();
    }

    @Override
    public ActionResponse delete(String l7policyId, String ruleId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)l7policyId) ? 1 : 0) != 0, (Object)"parameter `l7policyId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ruleId) ? 1 : 0) != 0, (Object)"parameter `l7policyId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/l7policies/%s/rules/%s", l7policyId, ruleId)).executeWithResponse());
    }
}

