/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.ext.NetQuotaService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.network.NetQuota;
import com.huawei.openstack4j.openstack.networking.domain.NeutronNetQuota;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;

public class NetQuotaServiceImpl
extends BaseNetworkingServices
implements NetQuotaService {
    @Override
    public List<? extends NetQuota> get() {
        return this.get(NeutronNetQuota.NeutronNetQuotas.class, this.uri("/quotas", new Object[0])).execute().getList();
    }

    @Override
    public NetQuota get(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"TenantId must not be null");
        return this.get(NeutronNetQuota.class, this.uri("/quotas/%s", tenantId)).execute();
    }

    @Override
    public NetQuota updateForTenant(String tenantId, NetQuota netQuota) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"TenantId must not be null");
        Preconditions.checkNotNull((Object)netQuota, (Object)"NetQuota must not be null");
        return this.put(NeutronNetQuota.class, this.uri("/quotas/%s", tenantId)).entity(netQuota).execute();
    }

    @Override
    public NetQuota update(NetQuota netQuota) {
        Preconditions.checkNotNull((Object)netQuota, (Object)"NetQuota must not be null");
        return this.put(NeutronNetQuota.class, this.uri("/quotas", new Object[0])).entity(netQuota).execute();
    }

    @Override
    public ActionResponse reset() {
        return this.deleteWithResponse(this.uri("/quotas", new Object[0])).execute();
    }

    @Override
    public ActionResponse reset(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"TenantId must not be null");
        return this.deleteWithResponse(this.uri("/quotas/%s", tenantId)).execute();
    }
}

