/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.ext.VipService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.network.ext.Vip;
import com.huawei.openstack4j.model.network.ext.VipUpdate;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.ext.NeutronVip;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class VipServiceImpl
extends BaseNetworkingServices
implements VipService {
    @Override
    public List<? extends Vip> list() {
        return this.get(NeutronVip.Vips.class, this.uri("/lb/vips", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Vip> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronVip.Vips> req = this.get(NeutronVip.Vips.class, this.uri("/lb/vips", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public Vip get(String vipId) {
        Preconditions.checkNotNull((Object)vipId);
        return this.get(NeutronVip.class, this.uri("/lb/vips/%s", vipId)).execute();
    }

    @Override
    public ActionResponse delete(String vipId) {
        Preconditions.checkNotNull((Object)vipId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lb/vips/%s", vipId)).executeWithResponse());
    }

    @Override
    public Vip create(Vip vip) {
        Preconditions.checkNotNull((Object)vip);
        return this.post(NeutronVip.class, this.uri("/lb/vips", new Object[0])).entity(vip).execute();
    }

    @Override
    public Vip update(String vipId, VipUpdate vip) {
        Preconditions.checkNotNull((Object)vipId);
        Preconditions.checkNotNull((Object)vip);
        return this.put(NeutronVip.class, this.uri("/lb/vips/%s", vipId)).entity(vip).execute();
    }
}

