/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.scaling.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.scaling.AutoScalingConfigService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.scaling.Disk;
import com.huawei.openstack4j.model.scaling.Eip;
import com.huawei.openstack4j.model.scaling.InstanceConfig;
import com.huawei.openstack4j.model.scaling.Personality;
import com.huawei.openstack4j.model.scaling.PublicIp;
import com.huawei.openstack4j.model.scaling.ScalingConfig;
import com.huawei.openstack4j.model.scaling.ScalingConfigCreate;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingConfig;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingConfigCreate;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingConfigDelete;
import com.huawei.openstack4j.openstack.scaling.internal.BaseAutoScalingServices;
import com.huawei.openstack4j.openstack.scaling.options.ScalingConfigListOptions;
import java.util.List;

public class AutoScalingConfigServiceImpl
extends BaseAutoScalingServices
implements AutoScalingConfigService {
    @Override
    public String create(ScalingConfigCreate config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getConfigName()) ? 1 : 0) != 0, (Object)"configName is required");
        Preconditions.checkArgument((config.getInstanceConfig() != null ? 1 : 0) != 0, (Object)"instanceConfig is required");
        this.checkDiskWhenPresent(config.getInstanceConfig().getDisks());
        this.checkPersonalityWhenPresent(config.getInstanceConfig().getPersonality());
        this.checkPublicIpWhenPresent(config.getInstanceConfig().getPublicIp());
        InstanceConfig instanceConfig = config.getInstanceConfig();
        if (Strings.isNullOrEmpty((String)instanceConfig.getInstanceId())) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceConfig.getFlavorRef()) ? 1 : 0) != 0, (Object)"flavorRef is required when instanceId not present");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceConfig.getImageRef()) ? 1 : 0) != 0, (Object)"imageRef is required when instanceId not present");
            this.checkDiskWhenInstanceIdNotPresent(instanceConfig.getDisks());
        } else {
            instanceConfig.setFlavorRef(null);
            instanceConfig.setImageRef(null);
            instanceConfig.setDisks(null);
        }
        ASAutoScalingConfigCreate execute = this.post(ASAutoScalingConfigCreate.class, this.uri("/scaling_configuration", new Object[0])).entity(config).execute();
        return execute.getConfigId();
    }

    private void checkPublicIpWhenPresent(PublicIp publicIp) {
        if (publicIp != null) {
            Eip eip = publicIp.getEip();
            Preconditions.checkArgument((eip != null ? 1 : 0) != 0, (Object)"eip is required");
            Preconditions.checkArgument((eip.getIpType() != null ? 1 : 0) != 0, (Object)"ipType is required");
            Preconditions.checkArgument((eip.getBandwidth() != null ? 1 : 0) != 0, (Object)"bandwidth is required");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)eip.getBandwidth().getSize()) ? 1 : 0) != 0, (Object)"bandwidth size is required");
            Preconditions.checkArgument((eip.getBandwidth().getShareType() != null ? 1 : 0) != 0, (Object)"bandwidth shareType is required");
            Preconditions.checkArgument((eip.getBandwidth().getChargingMode() != null ? 1 : 0) != 0, (Object)"bandwidth chargingMode is required");
        }
    }

    @Override
    public List<? extends ScalingConfig> list(ScalingConfigListOptions options) {
        return this.get(ASAutoScalingConfig.ASAutoScalingConfigs.class, this.uri("/scaling_configuration", new Object[0])).params(options.getOptions()).execute().getList();
    }

    @Override
    public List<? extends ScalingConfig> list() {
        return this.get(ASAutoScalingConfig.ASAutoScalingConfigs.class, this.uri("/scaling_configuration", new Object[0])).execute().getList();
    }

    @Override
    public ScalingConfig get(String configId) {
        Preconditions.checkNotNull((Object)configId, (Object)"configId");
        return this.get(ASAutoScalingConfig.class, this.uri("/scaling_configuration/%s", configId)).execute();
    }

    @Override
    public ActionResponse delete(String configId) {
        Preconditions.checkNotNull((Object)configId, (Object)"configId");
        return this.deleteWithResponse(this.uri("/scaling_configuration/%s", configId)).execute();
    }

    @Override
    public ActionResponse delete(List<String> configIds) {
        Preconditions.checkArgument((configIds != null && !configIds.isEmpty() ? 1 : 0) != 0, (Object)"configIds null or empty");
        return this.post(ActionResponse.class, this.uri("/scaling_configurations", new Object[0])).entity(ASAutoScalingConfigDelete.builder().configIds(configIds).build()).execute();
    }

    private void checkDiskWhenInstanceIdNotPresent(List<Disk> disks) {
        Preconditions.checkArgument((disks != null && !disks.isEmpty() ? 1 : 0) != 0, (Object)"disk is required when instanceId not present");
        for (Disk disk : disks) {
            Preconditions.checkNotNull((Object)disk.getSize(), (Object)"disk size");
            Preconditions.checkNotNull((Object)((Object)disk.getVolumeType()), (Object)"disk volume type");
            Preconditions.checkNotNull((Object)((Object)disk.getDiskType()), (Object)"disk type");
        }
    }

    private void checkPersonalityWhenPresent(List<Personality> personality) {
        if (personality != null) {
            for (Personality p : personality) {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)p.getPath()) ? 1 : 0) != 0, (Object)"personality path is required");
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)p.getContent()) ? 1 : 0) != 0, (Object)"personality content is required");
            }
        }
    }

    private void checkDiskWhenPresent(List<Disk> disks) {
        if (disks != null) {
            for (Disk disk : disks) {
                Preconditions.checkArgument((disk.getSize() != null ? 1 : 0) != 0, (Object)"diskSize is required");
                Preconditions.checkArgument((disk.getVolumeType() != null ? 1 : 0) != 0, (Object)"diskVolumeType is required");
                Preconditions.checkArgument((disk.getDiskType() != null ? 1 : 0) != 0, (Object)"diskType is required");
            }
        }
    }
}

