/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.scaling.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.scaling.AutoScalingLifecycleHookService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingLifecycleHook;
import com.huawei.openstack4j.openstack.scaling.domain.ASAutoScalingLifecycleInstanceCallback;
import com.huawei.openstack4j.openstack.scaling.domain.AutoScalingInstanceHangupInfo;
import com.huawei.openstack4j.openstack.scaling.internal.BaseAutoScalingServices;
import com.huawei.openstack4j.openstack.scaling.options.ScalingInstanceOptions;
import java.util.List;

public class AutoScalingLifecycleHookServiceImpl
extends BaseAutoScalingServices
implements AutoScalingLifecycleHookService {
    @Override
    public ASAutoScalingLifecycleHook create(ASAutoScalingLifecycleHook lifecycleHook, String groupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)lifecycleHook.getLifecycleHookName()) ? 1 : 0) != 0, (Object)"parameter `lifecycleHookName` should not be empty");
        Preconditions.checkArgument((lifecycleHook.getLifecycleHookType() != null ? 1 : 0) != 0, (Object)"parameter `lifecycleHookType` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)lifecycleHook.getNotificationTopicUrn()) ? 1 : 0) != 0, (Object)"parameter `notificationTopicUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"parameter `groupId` should not be empty");
        return this.post(ASAutoScalingLifecycleHook.class, this.uri("/scaling_lifecycle_hook/%s", groupId)).entity(lifecycleHook).execute();
    }

    @Override
    public List<? extends ASAutoScalingLifecycleHook> list(String groupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"parameter `groupId` should not be empty");
        return this.get(ASAutoScalingLifecycleHook.ASAutoScalingLifecycleHooks.class, this.uri("/scaling_lifecycle_hook/%s", groupId + "/list")).execute().getList();
    }

    @Override
    public ASAutoScalingLifecycleHook list(String groupId, String lifecycleHookName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"parameter `groupId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)lifecycleHookName) ? 1 : 0) != 0, (Object)"parameter `lifecycleHookName` should not be empty");
        return this.get(ASAutoScalingLifecycleHook.class, this.uri("/scaling_lifecycle_hook/%s", groupId + "/" + lifecycleHookName)).execute();
    }

    @Override
    public ASAutoScalingLifecycleHook update(String groupId, String lifecycleHookName, ASAutoScalingLifecycleHook lifecycleHook) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"parameter `groupId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)lifecycleHookName) ? 1 : 0) != 0, (Object)"parameter `lifecycleHookName` should not be empty");
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)lifecycleHook.getLifecycleHookName()), (Object)"parameter `lifecycleHookName` should not be modify");
        Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)lifecycleHook.getNotificationTopicName()), (Object)"parameter `notificationTopicName` should not be modify");
        return this.put(ASAutoScalingLifecycleHook.class, this.uri("/scaling_lifecycle_hook/%s", groupId + "/" + lifecycleHookName)).entity(lifecycleHook).execute();
    }

    @Override
    public List<? extends AutoScalingInstanceHangupInfo> scalingInstanceHangup(String groupId, ScalingInstanceOptions instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"parameter `groupId` should not be empty");
        return this.get(AutoScalingInstanceHangupInfo.AutoScalingInstanceHangupInfos.class, this.uri("/scaling_instance_hook/%s", groupId + "/list")).params(instanceId.getOptions()).execute().getList();
    }

    @Override
    public List<? extends AutoScalingInstanceHangupInfo> scalingInstanceHangup(String groupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"parameter `groupId` should not be empty");
        return this.get(AutoScalingInstanceHangupInfo.AutoScalingInstanceHangupInfos.class, this.uri("/scaling_instance_hook/%s", groupId + "/list")).execute().getList();
    }

    @Override
    public ActionResponse delete(String groupId, String lifecycleHookName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"parameter `groupId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)lifecycleHookName) ? 1 : 0) != 0, (Object)"parameter `lifecycleHookName` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/scaling_lifecycle_hook/%s", groupId + "/" + lifecycleHookName)).executeWithResponse());
    }

    @Override
    public ActionResponse scalingInstanceHookCallback(String groupId, ASAutoScalingLifecycleInstanceCallback lifecycleInstanceCallback) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"parameter `groupId` should not be empty");
        if (Strings.isNullOrEmpty((String)lifecycleInstanceCallback.getLifecycleActionKey())) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)lifecycleInstanceCallback.getInstanceId()) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)lifecycleInstanceCallback.getLifecycleHookName()) ? 1 : 0) != 0, (Object)"parameter `lifecycleHookName` should not be empty");
        }
        return ToActionResponseFunction.INSTANCE.apply(this.put(Void.class, this.uri("/scaling_instance_hook/%s", groupId + "/callback")).entity(lifecycleInstanceCallback).executeWithResponse());
    }
}

