/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.senlin.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.senlin.SenlinClusterService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.senlin.ActionID;
import com.huawei.openstack4j.model.senlin.Cluster;
import com.huawei.openstack4j.model.senlin.ClusterActionCreate;
import com.huawei.openstack4j.model.senlin.ClusterCreate;
import com.huawei.openstack4j.openstack.senlin.domain.SenlinActionID;
import com.huawei.openstack4j.openstack.senlin.domain.SenlinCluster;
import com.huawei.openstack4j.openstack.senlin.internal.BaseSenlinServices;
import java.util.List;

public class SenlinClusterServiceImpl
extends BaseSenlinServices
implements SenlinClusterService {
    @Override
    public List<? extends Cluster> list() {
        return this.get(SenlinCluster.Cluster.class, this.uri("/clusters", new Object[0])).execute().getList();
    }

    @Override
    public Cluster get(String clusterID) {
        Preconditions.checkNotNull((Object)clusterID);
        return this.get(SenlinCluster.class, this.uri("/clusters/%s", clusterID)).execute();
    }

    @Override
    public Cluster create(ClusterCreate newCluster) {
        Preconditions.checkNotNull((Object)newCluster);
        return this.post(SenlinCluster.class, this.uri("/clusters", new Object[0])).entity(newCluster).execute();
    }

    @Override
    public ActionResponse delete(String clusterID) {
        Preconditions.checkNotNull((Object)clusterID);
        return this.deleteWithResponse(this.uri("/clusters/%s", clusterID)).execute();
    }

    @Override
    public Cluster update(String clusterID, ClusterCreate newCluster) {
        Preconditions.checkNotNull((Object)clusterID);
        Preconditions.checkNotNull((Object)newCluster);
        return this.patch(SenlinCluster.class, this.uri("/clusters/%s", clusterID)).entity(newCluster).execute();
    }

    @Override
    public ActionID action(String clusterID, ClusterActionCreate newClusterAction) {
        Preconditions.checkNotNull((Object)clusterID);
        Preconditions.checkNotNull((Object)newClusterAction);
        return this.post(SenlinActionID.class, this.uri("/clusters/%s/actions", clusterID)).entity(newClusterAction).execute();
    }
}

