/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.senlin.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.senlin.SenlinPolicyService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.senlin.Policy;
import com.huawei.openstack4j.model.senlin.PolicyCreate;
import com.huawei.openstack4j.openstack.senlin.domain.SenlinPolicy;
import com.huawei.openstack4j.openstack.senlin.internal.BaseSenlinServices;
import java.util.List;

public class SenlinPolicyServiceImpl
extends BaseSenlinServices
implements SenlinPolicyService {
    @Override
    public List<? extends Policy> list() {
        return this.get(SenlinPolicy.Policy.class, this.uri("/policies", new Object[0])).execute().getList();
    }

    @Override
    public Policy create(PolicyCreate newPolicy) {
        Preconditions.checkNotNull((Object)newPolicy);
        return this.post(SenlinPolicy.class, this.uri("/policies", new Object[0])).entity(newPolicy).execute();
    }

    @Override
    public Policy get(String policyID) {
        Preconditions.checkNotNull((Object)policyID);
        return this.get(SenlinPolicy.class, this.uri("/policies/%s", policyID)).execute();
    }

    @Override
    public Policy update(String policyID, PolicyCreate newPolicy) {
        Preconditions.checkNotNull((Object)policyID);
        Preconditions.checkNotNull((Object)newPolicy);
        return this.patch(SenlinPolicy.class, this.uri("/policies/%s", policyID)).entity(newPolicy).execute();
    }

    @Override
    public ActionResponse delete(String policyID) {
        Preconditions.checkNotNull((Object)policyID);
        return this.deleteWithResponse(this.uri("/policies/%s", policyID)).execute();
    }
}

