/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.storage.block.BlockQuotaSet;
import com.huawei.openstack4j.model.storage.block.builder.BlockQuotaSetBuilder;

@JsonRootName(value="quota_set")
@JsonIgnoreProperties(ignoreUnknown=true)
public class CinderBlockQuotaSet
implements BlockQuotaSet {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty
    private int snapshots;
    @JsonProperty
    private int volumes;
    @JsonProperty
    private int gigabytes;

    public static BlockQuotaSetBuilder builder() {
        return new BlockQuotaSetConcreteBuilder();
    }

    @Override
    public BlockQuotaSetBuilder toBuilder() {
        return new BlockQuotaSetConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getSnapshots() {
        return this.snapshots;
    }

    @Override
    public int getVolumes() {
        return this.volumes;
    }

    @Override
    public int getGigabytes() {
        return this.gigabytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("snapshots", this.snapshots).add("volumes", this.volumes).add("gigabytes", this.gigabytes).toString();
    }

    public static class BlockQuotaSetConcreteBuilder
    implements BlockQuotaSetBuilder {
        private CinderBlockQuotaSet model;

        BlockQuotaSetConcreteBuilder() {
            this.model = new CinderBlockQuotaSet();
        }

        BlockQuotaSetConcreteBuilder(CinderBlockQuotaSet model) {
            this.model = model;
            this.model.id = null;
        }

        @Override
        public BlockQuotaSet build() {
            return this.model;
        }

        @Override
        public BlockQuotaSetBuilder from(BlockQuotaSet in) {
            return new BlockQuotaSetConcreteBuilder((CinderBlockQuotaSet)in);
        }

        @Override
        public BlockQuotaSetBuilder volumes(int volumes) {
            this.model.volumes = volumes;
            return this;
        }

        @Override
        public BlockQuotaSetBuilder snapshots(int snapshots) {
            this.model.snapshots = snapshots;
            return this;
        }

        @Override
        public BlockQuotaSetBuilder gigabytes(int gigabytes) {
            this.model.gigabytes = gigabytes;
            return this;
        }
    }
}

