/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.storage.block.Volume;
import com.huawei.openstack4j.model.storage.block.VolumeSnapshot;
import com.huawei.openstack4j.model.storage.block.builder.VolumeSnapshotBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonRootName(value="snapshot")
public class CinderVolumeSnapshot
implements VolumeSnapshot {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="volume_id")
    private String volumeId;
    private Volume.Status status;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonProperty(value="size")
    private Integer size;
    @JsonProperty(value="created_at")
    private Date created;
    @JsonProperty
    private Boolean force;
    @JsonProperty(value="metadata")
    private Map<String, String> metadata;
    @JsonProperty(value="updated_at")
    private String updatedAt;
    @JsonProperty(value="os-extended-snapshot-attributes:project_id")
    private String projectId;
    @JsonProperty(value="os-extended-snapshot-attributes:progress")
    private String progress;

    @Override
    public VolumeSnapshotBuilder toBuilder() {
        return new ConcreteVolumeSnapshotBuilder(this);
    }

    public static VolumeSnapshotBuilder builder() {
        return new ConcreteVolumeSnapshotBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getVolumeId() {
        return this.volumeId;
    }

    @Override
    public Volume.Status getStatus() {
        return this.status;
    }

    @Override
    public int getSize() {
        return this.size != null ? this.size : 0;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getMetaData() {
        return this.metadata;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProgress() {
        return this.progress;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("volumeId", (Object)this.volumeId).add("status", (Object)this.status).add("created", (Object)this.created).add("force", (Object)this.force).add("size", (Object)this.size).add("metadata", this.metadata).add("projectId", (Object)this.projectId).add("progress", (Object)this.progress).add("updatedAt", (Object)this.updatedAt).toString();
    }

    public static class ConcreteVolumeSnapshotBuilder
    implements VolumeSnapshotBuilder {
        private CinderVolumeSnapshot m;

        ConcreteVolumeSnapshotBuilder() {
            this(new CinderVolumeSnapshot());
        }

        ConcreteVolumeSnapshotBuilder(CinderVolumeSnapshot m) {
            this.m = m;
        }

        @Override
        public VolumeSnapshotBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public VolumeSnapshotBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public VolumeSnapshotBuilder volume(String volumeId) {
            this.m.volumeId = volumeId;
            return this;
        }

        @Override
        public VolumeSnapshotBuilder force(boolean force) {
            this.m.force = force;
            return this;
        }

        @Override
        public VolumeSnapshotBuilder metadata(Map<String, String> metadata) {
            this.m.metadata = metadata;
            return this;
        }

        @Override
        public VolumeSnapshot build() {
            return this.m;
        }

        @Override
        public VolumeSnapshotBuilder from(VolumeSnapshot in) {
            this.m = (CinderVolumeSnapshot)in;
            return this;
        }
    }

    public static class VolumeSnapshots
    extends ListResult<CinderVolumeSnapshot> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="snapshots")
        private List<CinderVolumeSnapshot> snapshots;

        @Override
        protected List<CinderVolumeSnapshot> value() {
            return this.snapshots;
        }
    }
}

