/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.storage.block.VolumeType;
import com.huawei.openstack4j.model.storage.block.builder.VolumeTypeBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.util.List;
import java.util.Map;

@JsonRootName(value="volume_type")
public class CinderVolumeType
implements VolumeType {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    @JsonProperty(value="qos_specs_id")
    private String qosSpecsId;
    @JsonProperty(value="is_public")
    private Boolean isPublic;
    @JsonProperty(value="extra_specs")
    private Map<String, String> extraSpecs;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getExtraSpecs() {
        return this.extraSpecs;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getQosSpecsId() {
        return this.qosSpecsId;
    }

    @Override
    public Boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public VolumeTypeBuilder toBuilder() {
        return new ConcreteVolumeTypeBuilder(this);
    }

    public static VolumeTypeBuilder builder() {
        return new ConcreteVolumeTypeBuilder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("extras", this.extraSpecs).add("description", (Object)this.description).add("isPublic", (Object)this.isPublic).add("qosSpecsId", (Object)this.qosSpecsId).toString();
    }

    public static class ConcreteVolumeTypeBuilder
    implements VolumeTypeBuilder {
        private CinderVolumeType m;

        ConcreteVolumeTypeBuilder() {
            this(new CinderVolumeType());
        }

        ConcreteVolumeTypeBuilder(CinderVolumeType volumeType) {
            this.m = volumeType;
        }

        @Override
        public VolumeType build() {
            return this.m;
        }

        @Override
        public VolumeTypeBuilder from(VolumeType in) {
            this.m = (CinderVolumeType)in;
            return this;
        }

        @Override
        public VolumeTypeBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public VolumeTypeBuilder extraSpecs(Map<String, String> extraSpecs) {
            this.m.extraSpecs = extraSpecs;
            return this;
        }
    }

    public static class VolumeTypes
    extends ListResult<CinderVolumeType> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="volume_types")
        private List<CinderVolumeType> types;

        @Override
        protected List<CinderVolumeType> value() {
            return this.types;
        }
    }
}

