/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.storage.BlockQuotaSetService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.storage.block.BlockQuotaSet;
import com.huawei.openstack4j.model.storage.block.BlockQuotaSetUsage;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderBlockQuotaSet;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderBlockQuotaSetResponse;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderBlockQuotaSetUsage;
import com.huawei.openstack4j.openstack.storage.block.internal.BaseBlockStorageServices;

public class BlockQuotaSetServiceImpl
extends BaseBlockStorageServices
implements BlockQuotaSetService {
    @Override
    public BlockQuotaSet getDefaults(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"Tenant cannot be null");
        return this.get(CinderBlockQuotaSet.class, this.uri("/os-quota-sets/%s/defaults", tenantId)).execute();
    }

    @Override
    public BlockQuotaSet get(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"Tenant cannot be null");
        return this.get(CinderBlockQuotaSet.class, this.uri("/os-quota-sets/%s", tenantId)).param("usage", false).execute();
    }

    @Override
    public BlockQuotaSet updateForTenant(String tenantId, BlockQuotaSet quota) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"Tenant cannot be null");
        Preconditions.checkNotNull((Object)quota, (Object)"Quota cannot be null");
        return this.put(CinderBlockQuotaSet.class, this.uri("/os-quota-sets/%s", tenantId)).entity(quota).execute();
    }

    @Override
    public ActionResponse delete(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"Tenant cannot be null");
        return this.delete(ActionResponse.class, this.uri("/os-quota-sets/%s", tenantId)).execute();
    }

    @Override
    public BlockQuotaSetUsage usageForTenant(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"Tenant cannot be null");
        return this.get(CinderBlockQuotaSetUsage.class, this.uri("/os-quota-sets/%s", tenantId)).param("usage", true).execute();
    }

    @Override
    public CinderBlockQuotaSetResponse quotaForTenant(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"Tenant cannot be null");
        return this.get(CinderBlockQuotaSetResponse.class, this.uri("/os-quota-sets/%s", tenantId)).param("usage", true).execute();
    }

    @Override
    public BlockQuotaSetUsage usageForUser(String tenantId, String userId) {
        Preconditions.checkNotNull((Object)tenantId, (Object)"Tenant cannot be null");
        Preconditions.checkNotNull((Object)userId, (Object)"User cannot be null");
        return this.get(CinderBlockQuotaSetUsage.class, this.uri("/os-quota-sets/%s", tenantId)).param("user_id", userId).param("usage", true).execute();
    }
}

