/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.storage.BlockVolumeBackupService;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.storage.block.VolumeBackup;
import com.huawei.openstack4j.model.storage.block.VolumeBackupCreate;
import com.huawei.openstack4j.model.storage.block.VolumeBackupRestore;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolumeBackup;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolumeBackupRestore;
import com.huawei.openstack4j.openstack.storage.block.internal.BaseBlockStorageServices;
import java.util.List;
import java.util.Map;

public class BlockVolumeBackupServiceImpl
extends BaseBlockStorageServices
implements BlockVolumeBackupService {
    @Override
    public List<? extends VolumeBackup> list(boolean detail) {
        String uri = detail ? "/backups/detail" : "/backups";
        return this.get(CinderVolumeBackup.VolumeBackups.class, uri).execute().getList();
    }

    @Override
    public List<? extends VolumeBackup> list(boolean detail, Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolumeBackup.VolumeBackups> invocation = this.buildInvocation(detail, filteringParams);
        return invocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<CinderVolumeBackup.VolumeBackups> buildInvocation(boolean detail, Map<String, String> filteringParams) {
        String uri = detail ? "/backups/detail" : "/backups";
        BaseOpenStackService.Invocation<CinderVolumeBackup.VolumeBackups> invocation = this.get(CinderVolumeBackup.VolumeBackups.class, uri);
        if (filteringParams == null) {
            return invocation;
        }
        for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
            invocation = invocation.param(entry.getKey(), entry.getValue());
        }
        return invocation;
    }

    @Override
    public VolumeBackup get(String backupId) {
        Preconditions.checkNotNull((Object)backupId);
        return this.get(CinderVolumeBackup.class, this.uri("/backups/%s", backupId)).execute();
    }

    @Override
    public ActionResponse delete(String backupId) {
        Preconditions.checkNotNull((Object)backupId);
        return this.deleteWithResponse(this.uri("/backups/%s", backupId)).execute();
    }

    @Override
    public VolumeBackup create(VolumeBackupCreate vbc) {
        Preconditions.checkNotNull((Object)vbc);
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)vbc.getVolumeId()) ? 1 : 0), (Object)"parameter `vbc.volumeId` should not be empty");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)vbc.getSnapshotId()) ? 1 : 0), (Object)"parameter `vbc.snapshotId` should not be empty");
        return this.post(CinderVolumeBackup.class, this.uri("/backups", new Object[0])).entity(vbc).execute();
    }

    @Override
    public VolumeBackupRestore restore(String backupId, String name, String volumeId) {
        _VolumeBackupRestore entity = new _VolumeBackupRestore(name, volumeId);
        return this.post(CinderVolumeBackupRestore.class, this.uri("/backups/%s/restore", backupId)).entity(entity).execute();
    }

    @JsonRootName(value="restore")
    private static class _VolumeBackupRestore
    implements ModelEntity {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="volume_id")
        private String volumeId;

        public _VolumeBackupRestore(String name, String volumeId) {
            this.name = name;
            this.volumeId = volumeId;
        }
    }
}

