/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.api.Builders;
import com.huawei.openstack4j.api.storage.BlockVolumeService;
import com.huawei.openstack4j.api.storage.BlockVolumeTransferService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.storage.block.Volume;
import com.huawei.openstack4j.model.storage.block.VolumeType;
import com.huawei.openstack4j.model.storage.block.VolumeUploadImage;
import com.huawei.openstack4j.model.storage.block.options.UploadImageData;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.storage.block.domain.AttachAction;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderUploadImageData;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolume;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolumeMigration;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolumeType;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolumeUpdate;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolumeUploadImage;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolumesResponse;
import com.huawei.openstack4j.openstack.storage.block.domain.ExtendAction;
import com.huawei.openstack4j.openstack.storage.block.domain.Extension;
import com.huawei.openstack4j.openstack.storage.block.domain.ForceDeleteAction;
import com.huawei.openstack4j.openstack.storage.block.domain.ForceDetachAction;
import com.huawei.openstack4j.openstack.storage.block.domain.ForceDetachConnector;
import com.huawei.openstack4j.openstack.storage.block.domain.ResetStatusAction;
import com.huawei.openstack4j.openstack.storage.block.domain.UpdateReadOnlyFlagAction;
import com.huawei.openstack4j.openstack.storage.block.domain.VolumeMeta;
import com.huawei.openstack4j.openstack.storage.block.domain.VolumeMetadata;
import com.huawei.openstack4j.openstack.storage.block.internal.BaseBlockStorageServices;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockVolumeServiceImpl
extends BaseBlockStorageServices
implements BlockVolumeService {
    @Override
    public List<? extends VolumeType> listVolumeTypes() {
        return this.get(CinderVolumeType.VolumeTypes.class, this.uri("/types", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Volume> list() {
        return this.get(CinderVolume.Volumes.class, this.uri("/volumes/detail", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Volume> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolume.Volumes> volumeInvocation = this.buildInvocation(filteringParams);
        return volumeInvocation.execute().getList();
    }

    @Override
    public Volume get(String volumeId) {
        Preconditions.checkNotNull((Object)volumeId);
        return this.get(CinderVolume.class, this.uri("/volumes/%s", volumeId)).execute();
    }

    @Override
    public ActionResponse delete(String volumeId) {
        Preconditions.checkNotNull((Object)volumeId);
        return this.deleteWithResponse(this.uri("/volumes/%s", volumeId)).execute();
    }

    @Override
    public ActionResponse forceDelete(String volumeId, Boolean cascade) {
        Preconditions.checkNotNull((Object)volumeId);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("cascade", cascade);
        return this.deleteWithResponse(this.uri("/volumes/%s", volumeId)).params(params).execute();
    }

    @Override
    public ActionResponse forceDelete(String volumeId) {
        Preconditions.checkNotNull((Object)volumeId);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(new ForceDeleteAction()).execute();
    }

    @Override
    public ActionResponse resetState(String volumeId, Volume.Status status) {
        Preconditions.checkNotNull((Object)volumeId);
        Preconditions.checkNotNull((Object)((Object)status));
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(new ResetStatusAction(status)).execute();
    }

    @Override
    public ActionResponse extend(String volumeId, Integer newSize) {
        Preconditions.checkNotNull((Object)volumeId);
        Preconditions.checkNotNull((Object)newSize);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(new ExtendAction(newSize)).execute();
    }

    @Override
    public Volume create(Volume volume) {
        Preconditions.checkNotNull((Object)volume);
        return this.post(CinderVolume.class, this.uri("/volumes", new Object[0])).entity(volume).execute();
    }

    @Override
    public Volume create(Volume volume, Map<String, Object> schedulerHints) {
        Preconditions.checkNotNull((Object)volume);
        if (schedulerHints == null || schedulerHints.isEmpty()) {
            return this.create(volume);
        }
        HashMap repackage = Maps.newHashMap();
        repackage.put("volume", volume);
        repackage.put("OS-SCH-HNT:scheduler_hints", schedulerHints);
        return this.post(CinderVolume.class, this.uri("/volumes", new Object[0])).entity(repackage).execute();
    }

    @Override
    public ActionResponse update(String volumeId, String name, String description) {
        Preconditions.checkNotNull((Object)volumeId);
        if (name == null && description == null) {
            return ActionResponse.actionFailed("Name and Description are both required", 412);
        }
        return this.put(ActionResponse.class, this.uri("/volumes/%s", volumeId)).entity(Builders.volume().name(name).description(description).build()).execute();
    }

    @Override
    public Volume update(String volumeId, CinderVolumeUpdate volume) {
        Preconditions.checkNotNull((Object)volumeId);
        return this.put(CinderVolume.class, this.uri("/volumes/%s", volumeId)).entity(volume).execute();
    }

    @Override
    public void deleteVolumeType(String volumeTypeId) {
        Preconditions.checkNotNull((Object)volumeTypeId);
        this.delete(Void.class, this.uri("/types/%s", volumeTypeId)).execute();
    }

    @Override
    public VolumeType createVolumeType(VolumeType volumeType) {
        Preconditions.checkNotNull((Object)volumeType);
        return this.post(CinderVolumeType.class, this.uri("/types", new Object[0])).entity(volumeType).execute();
    }

    @Override
    public ActionResponse migrate(String volumeId, String hostService, boolean forceHostCopy) {
        CinderVolumeMigration migration = new CinderVolumeMigration(hostService, forceHostCopy);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(migration).execute();
    }

    @Override
    public VolumeUploadImage uploadToImage(String volumeId, UploadImageData data) {
        Preconditions.checkNotNull((Object)volumeId, (Object)"volumeId");
        Preconditions.checkNotNull((Object)data, (Object)"UploadImageData");
        return this.post(CinderVolumeUploadImage.class, this.uri("/volumes/%s/action", volumeId)).entity(CinderUploadImageData.create(data)).execute();
    }

    @Override
    public BlockVolumeTransferService transfer() {
        return Apis.get(BlockVolumeTransferService.class);
    }

    private BaseOpenStackService.Invocation<CinderVolume.Volumes> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolume.Volumes> volumeInvocation = this.get(CinderVolume.Volumes.class, "/volumes/detail");
        if (filteringParams == null) {
            return volumeInvocation;
        }
        for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
            volumeInvocation = volumeInvocation.param(entry.getKey(), entry.getValue());
        }
        return volumeInvocation;
    }

    @Override
    public ActionResponse readOnlyModeUpdate(String volumeId, boolean readonly) {
        Preconditions.checkNotNull((Object)volumeId);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(new UpdateReadOnlyFlagAction(readonly)).execute();
    }

    @Override
    public ActionResponse attach(String volumeId, String instanceId, String mountpoint, String hostName) {
        Preconditions.checkNotNull((Object)volumeId);
        Preconditions.checkNotNull((Object)instanceId);
        Preconditions.checkNotNull((Object)mountpoint);
        Preconditions.checkNotNull((Object)hostName);
        AttachAction attach = new AttachAction(instanceId, mountpoint, hostName);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(attach).execute();
    }

    @Override
    public ActionResponse forceDetach(String volumeId, String initiator, String attachmentId) {
        Preconditions.checkNotNull((Object)volumeId);
        Preconditions.checkNotNull((Object)initiator);
        Preconditions.checkNotNull((Object)attachmentId);
        ForceDetachConnector connector = new ForceDetachConnector(initiator);
        ForceDetachAction detach = new ForceDetachAction(attachmentId, connector);
        return this.post(ActionResponse.class, this.uri("/volumes/%s/action", volumeId)).entity(detach).execute();
    }

    @Override
    public ActionResponse setBootable(String volumeId, boolean bootable) {
        Preconditions.checkNotNull((Object)volumeId);
        Preconditions.checkNotNull((Object)bootable);
        HashMap map = Maps.newHashMap();
        map.put("bootable", bootable);
        HashMap param = Maps.newHashMap();
        param.put("os-set_bootable", map);
        return this.postWithResponse(this.uri("/volumes/%s/action", volumeId)).entity(param).execute();
    }

    @Override
    public CinderVolumesResponse listVolumes() {
        return this.get(CinderVolumesResponse.class, "/volumes").execute();
    }

    @Override
    public CinderVolumesResponse listVolumes(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolumesResponse> volumeInvocation = this.get(CinderVolumesResponse.class, "/volumes");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                volumeInvocation = volumeInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return volumeInvocation.execute();
    }

    @Override
    public VolumeType getVolumeType(String typeId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)typeId) ? 1 : 0) != 0, (Object)"`typeId` should not be empty");
        return this.get(CinderVolumeType.class, this.uri("/types/%s", typeId)).execute();
    }

    @Override
    public VolumeMetadata createMetadata(String volumeId, VolumeMetadata metadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)volumeId) ? 1 : 0) != 0, (Object)"`volumeId` should not be empty");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"`metadata` is required");
        return this.post(VolumeMetadata.class, this.uri("/volumes/%s/metadata", volumeId)).entity(metadata).execute();
    }

    @Override
    public VolumeMetadata getMetadata(String volumeId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)volumeId) ? 1 : 0) != 0, (Object)"`volumeId` should not be empty");
        return this.get(VolumeMetadata.class, this.uri("/volumes/%s/metadata", volumeId)).execute();
    }

    @Override
    public VolumeMeta getMeta(String volumeId, String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)volumeId) ? 1 : 0) != 0, (Object)"`volumeId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"`key` should not be empty");
        return this.get(VolumeMeta.class, this.uri("/volumes/%s/metadata/%s", volumeId, key)).execute();
    }

    @Override
    public VolumeMetadata updateMetadata(String volumeId, VolumeMetadata metadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)volumeId) ? 1 : 0) != 0, (Object)"`volumeId` should not be empty");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"`metadata` is required");
        return this.put(VolumeMetadata.class, this.uri("/volumes/%s/metadata", volumeId)).entity(metadata).execute();
    }

    @Override
    public VolumeMeta updateMeta(String volumeId, String key, VolumeMeta metadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)volumeId) ? 1 : 0) != 0, (Object)"`volumeId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"`key` should not be empty");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"`metadata` is required");
        return this.put(VolumeMeta.class, this.uri("/volumes/%s/metadata/%s", volumeId, key)).entity(metadata).execute();
    }

    @Override
    public ActionResponse deleteMetadata(String volumeId, String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)volumeId) ? 1 : 0) != 0, (Object)"`volumeId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"`key` should not be empty");
        return this.deleteWithResponse(this.uri("/volumes/%s/metadata/%s", volumeId, key)).execute();
    }

    @Override
    public List<? extends Extension> listExtensions() {
        return this.get(Extension.Extensions.class, "/extensions").execute().getList();
    }
}

