/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.Builders;
import com.huawei.openstack4j.api.storage.BlockVolumeSnapshotService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.storage.block.VolumeSnapshot;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolumeSnapshot;
import com.huawei.openstack4j.openstack.storage.block.domain.CinderVolumeSnapshotsResponse;
import com.huawei.openstack4j.openstack.storage.block.domain.SnapshotDetail;
import com.huawei.openstack4j.openstack.storage.block.domain.SnapshotMeta;
import com.huawei.openstack4j.openstack.storage.block.domain.SnapshotMetadata;
import com.huawei.openstack4j.openstack.storage.block.domain.SnapshotUpdate;
import com.huawei.openstack4j.openstack.storage.block.internal.BaseBlockStorageServices;
import java.util.List;
import java.util.Map;

public class BlockVolumeSnapshotServiceImpl
extends BaseBlockStorageServices
implements BlockVolumeSnapshotService {
    @Override
    public List<? extends VolumeSnapshot> list() {
        return this.get(CinderVolumeSnapshot.VolumeSnapshots.class, this.uri("/snapshots", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends VolumeSnapshot> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolumeSnapshot.VolumeSnapshots> volumeInvocation = this.buildInvocation(filteringParams);
        return volumeInvocation.execute().getList();
    }

    @Override
    public VolumeSnapshot get(String snapshotId) {
        Preconditions.checkNotNull((Object)snapshotId);
        return this.get(CinderVolumeSnapshot.class, this.uri("/snapshots/%s", snapshotId)).execute();
    }

    @Override
    public ActionResponse delete(String snapshotId) {
        Preconditions.checkNotNull((Object)snapshotId);
        return this.deleteWithResponse(this.uri("/snapshots/%s", snapshotId)).execute();
    }

    @Override
    public ActionResponse update(String snapshotId, String name, String description) {
        Preconditions.checkNotNull((Object)snapshotId);
        if (name == null && description == null) {
            return ActionResponse.actionFailed("Both Name and Description are required", 412);
        }
        return this.put(ActionResponse.class, this.uri("/snapshots/%s", snapshotId)).entity(Builders.volumeSnapshot().name(name).description(description).build()).execute();
    }

    @Override
    public VolumeSnapshot create(VolumeSnapshot snapshot) {
        Preconditions.checkNotNull((Object)snapshot);
        Preconditions.checkNotNull((Object)snapshot.getVolumeId());
        return this.post(CinderVolumeSnapshot.class, this.uri("/snapshots", new Object[0])).entity(snapshot).execute();
    }

    @Override
    public SnapshotDetail update(String snapshotId, SnapshotUpdate snapshot) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotId) ? 1 : 0) != 0, (Object)"`snapshotId` should not be empty");
        Preconditions.checkNotNull((Object)snapshot, (Object)"`snapshot` is required");
        return this.put(SnapshotDetail.class, this.uri("/snapshots/%s", snapshotId)).entity(snapshot).execute();
    }

    @Override
    public CinderVolumeSnapshotsResponse listDetail() {
        return this.get(CinderVolumeSnapshotsResponse.class, "/snapshots/detail").execute();
    }

    @Override
    public CinderVolumeSnapshotsResponse listDetail(Map<String, String> filteringParams) {
        Preconditions.checkNotNull(filteringParams, (Object)"`filteringParams` is required");
        return this.get(CinderVolumeSnapshotsResponse.class, "/snapshots/detail").params(filteringParams).execute();
    }

    @Override
    public SnapshotMetadata createMetadata(String snapshotId, SnapshotMetadata metadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotId) ? 1 : 0) != 0, (Object)"`snapshotId` should not be empty");
        Preconditions.checkNotNull((Object)metadata, (Object)"`metadata` is required");
        return this.post(SnapshotMetadata.class, this.uri("/snapshots/%s/metadata", snapshotId)).entity(metadata).execute();
    }

    @Override
    public SnapshotMetadata getMetadata(String snapshotId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotId) ? 1 : 0) != 0, (Object)"`snapshotId` should not be empty");
        return this.get(SnapshotMetadata.class, this.uri("/snapshots/%s/metadata", snapshotId)).execute();
    }

    @Override
    public SnapshotMetadata updateMetadata(String snapshotId, SnapshotMetadata metadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotId) ? 1 : 0) != 0, (Object)"`snapshotId` should not be empty");
        Preconditions.checkNotNull((Object)metadata, (Object)"`metadata` is required");
        return this.put(SnapshotMetadata.class, this.uri("/snapshots/%s/metadata", snapshotId)).entity(metadata).execute();
    }

    @Override
    public ActionResponse deleteMeta(String snapshotId, String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotId) ? 1 : 0) != 0, (Object)"`snapshotId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"`key` should not be empty");
        return this.deleteWithResponse(this.uri("/snapshots/%s/metadata/%s", snapshotId, key)).execute();
    }

    @Override
    public SnapshotMeta getMeta(String snapshotId, String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotId) ? 1 : 0) != 0, (Object)"`snapshotId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"`key` should not be empty");
        return this.get(SnapshotMeta.class, this.uri("/snapshots/%s/metadata/%s", snapshotId, key)).execute();
    }

    @Override
    public SnapshotMeta updateMeta(String snapshotId, String key, SnapshotMeta metadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotId) ? 1 : 0) != 0, (Object)"`snapshotId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"`key` should not be empty");
        Preconditions.checkNotNull((Object)metadata, (Object)"`metadata` is required");
        return this.put(SnapshotMeta.class, this.uri("/snapshots/%s/metadata/%s", snapshotId, key)).entity(metadata).execute();
    }

    private BaseOpenStackService.Invocation<CinderVolumeSnapshot.VolumeSnapshots> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolumeSnapshot.VolumeSnapshots> volumeInvocation = this.get(CinderVolumeSnapshot.VolumeSnapshots.class, "/snapshots");
        if (filteringParams == null) {
            return volumeInvocation;
        }
        for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
            volumeInvocation = volumeInvocation.param(entry.getKey(), entry.getValue());
        }
        return volumeInvocation;
    }
}

