/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.block.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.api.storage.AsyncVolumeBackupJobService;
import com.huawei.openstack4j.api.storage.AsyncVolumeBackupService;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.storage.block.AsyncVolumeBackupCreate;
import com.huawei.openstack4j.model.storage.block.AsyncVolumeBackupJob;
import com.huawei.openstack4j.openstack.storage.block.domain.VBSVolumeBackupJob;
import com.huawei.openstack4j.openstack.storage.block.internal.BaseVolumeBackupServices;

public class VBSVolumeBackupServiceImpl
extends BaseVolumeBackupServices
implements AsyncVolumeBackupService {
    @Override
    public AsyncVolumeBackupJob create(AsyncVolumeBackupCreate cvbc) {
        Preconditions.checkNotNull((Object)cvbc);
        Preconditions.checkNotNull((Object)cvbc.getName());
        Preconditions.checkNotNull((Object)cvbc.getVolumeId());
        return this.post(VBSVolumeBackupJob.class, "/cloudbackups").entity(cvbc).execute();
    }

    @Override
    public AsyncVolumeBackupJob restore(String volumeBackupId, String volumeId) {
        Preconditions.checkNotNull((Object)volumeBackupId);
        Preconditions.checkNotNull((Object)volumeId);
        _AsyncVolumeBackupRestore entity = new _AsyncVolumeBackupRestore(volumeId);
        return this.post(VBSVolumeBackupJob.class, "/cloudbackups", "/", volumeBackupId, "/restore").entity(entity).execute();
    }

    @Override
    public AsyncVolumeBackupJobService jobs() {
        return Apis.get(AsyncVolumeBackupJobService.class);
    }

    @JsonRootName(value="restore")
    private static class _AsyncVolumeBackupRestore
    implements ModelEntity {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="volume_id")
        private String volumeId;

        public _AsyncVolumeBackupRestore(String volumeId) {
            this.volumeId = volumeId;
        }
    }
}

