/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.object.functions;

import com.google.common.base.Function;
import com.huawei.openstack4j.core.transport.HttpResponse;
import com.huawei.openstack4j.model.storage.object.SwiftObject;
import com.huawei.openstack4j.model.storage.object.options.ObjectLocation;
import com.huawei.openstack4j.openstack.internal.Parser;
import com.huawei.openstack4j.openstack.storage.object.domain.SwiftObjectImpl;
import com.huawei.openstack4j.openstack.storage.object.functions.MapWithoutMetaPrefixFunction;

public class ParseObjectFunction
implements Function<HttpResponse, SwiftObject> {
    private ObjectLocation location;

    private ParseObjectFunction(ObjectLocation location) {
        this.location = location;
    }

    public static ParseObjectFunction create(ObjectLocation location) {
        return new ParseObjectFunction(location);
    }

    public SwiftObject apply(HttpResponse resp) {
        return SwiftObjectImpl.builder().name(this.location.getObjectName()).containerName(this.location.getContainerName()).mimeType(resp.header("Content-Type")).sizeBytes(Parser.asLong(resp.header("Content-Length"))).eTag(resp.header("ETag")).metadata(MapWithoutMetaPrefixFunction.INSTANCE.apply(resp.headers())).lastModified(Parser.toRFC822DateParse(resp.header("Last-Modified"))).build();
    }
}

