/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.storage.object.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.storage.ObjectStorageAccountService;
import com.huawei.openstack4j.model.storage.object.SwiftAccount;
import com.huawei.openstack4j.openstack.storage.object.functions.MetadataToHeadersFunction;
import com.huawei.openstack4j.openstack.storage.object.functions.ParseAccountFunction;
import com.huawei.openstack4j.openstack.storage.object.internal.BaseObjectStorageService;
import java.util.Map;

public class ObjectStorageAccountServiceImpl
extends BaseObjectStorageService
implements ObjectStorageAccountService {
    @Override
    public SwiftAccount get() {
        return ParseAccountFunction.INSTANCE.apply(this.head(Void.class, new String[0]).executeWithResponse());
    }

    @Override
    public boolean updateMetadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata);
        return this.invokeMetadata("X-Account-Meta-", metadata);
    }

    @Override
    public boolean deleteMetadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata);
        return this.invokeMetadata("X-Remove-Account-Meta-", metadata);
    }

    @Override
    public boolean updateTemporaryUrlKey(String temporaryUrlKey) {
        Preconditions.checkNotNull((Object)temporaryUrlKey);
        return this.isResponseSuccess(this.post(Void.class, new String[0]).header("X-Account-Meta-Temp-Url-Key", temporaryUrlKey).executeWithResponse(), 204);
    }

    private boolean invokeMetadata(String prefix, Map<String, String> metadata) {
        return this.isResponseSuccess(this.post(Void.class, new String[0]).headers(MetadataToHeadersFunction.create(prefix).apply(metadata)).executeWithResponse(), 204);
    }
}

