/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.tacker.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.tacker.VnfService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.tacker.Vnf;
import com.huawei.openstack4j.model.tacker.VnfUpdate;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.tacker.domain.TackerVnf;
import com.huawei.openstack4j.openstack.tacker.internal.BaseTackerServices;
import java.util.List;
import java.util.Map;

public class VnfServiceImpl
extends BaseTackerServices
implements VnfService {
    public List<? extends TackerVnf> list() {
        return this.get(TackerVnf.TackerVnfs.class, this.uri("/vnfs", new Object[0])).execute().getList();
    }

    public List<? extends TackerVnf> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<TackerVnf.TackerVnfs> req = this.get(TackerVnf.TackerVnfs.class, this.uri("/vnfs", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public TackerVnf get(String vnfId) {
        Preconditions.checkNotNull((Object)vnfId);
        return this.get(TackerVnf.class, this.uri("/vnfs/%s", vnfId)).execute();
    }

    @Override
    public ActionResponse delete(String vnfId) {
        Preconditions.checkNotNull((Object)vnfId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vnfs/%s", vnfId)).executeWithResponse());
    }

    @Override
    public Vnf create(Vnf vnf) {
        return this.post(TackerVnf.class, this.uri("/vnfs", new Object[0])).entity(vnf).execute(ExecutionOptions.create(PropagateOnStatus.on(500)));
    }

    @Override
    public Vnf update(String vnfId, VnfUpdate vnfUpdate) {
        Preconditions.checkNotNull((Object)vnfId);
        Preconditions.checkNotNull((Object)vnfUpdate);
        return this.put(TackerVnf.class, this.uri("/vnfs/%s", vnfId)).entity(vnfUpdate).execute();
    }
}

