/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.tacker.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.tacker.VnfdService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.tacker.Vnfd;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.tacker.domain.TackerVnfd;
import com.huawei.openstack4j.openstack.tacker.internal.BaseTackerServices;
import java.util.List;
import java.util.Map;

public class VnfdServiceImpl
extends BaseTackerServices
implements VnfdService {
    public List<? extends TackerVnfd> list() {
        return this.get(TackerVnfd.TackerVnfds.class, this.uri("/vnfds", new Object[0])).execute().getList();
    }

    public List<? extends TackerVnfd> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<TackerVnfd.TackerVnfds> req = this.get(TackerVnfd.TackerVnfds.class, this.uri("/vnfds", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public TackerVnfd get(String vnfdId) {
        Preconditions.checkNotNull((Object)vnfdId);
        return this.get(TackerVnfd.class, this.uri("/vnfds/%s", vnfdId)).execute();
    }

    @Override
    public ActionResponse delete(String vnfdId) {
        Preconditions.checkNotNull((Object)vnfdId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vnfds/%s", vnfdId)).executeWithResponse());
    }

    @Override
    public Vnfd create(Vnfd vnfd) {
        return this.post(TackerVnfd.class, this.uri("/vnfds", new Object[0])).entity(vnfd).execute(ExecutionOptions.create(PropagateOnStatus.on(500)));
    }
}

