/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.telemetry.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.telemetry.AlarmService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.telemetry.Alarm;
import com.huawei.openstack4j.openstack.telemetry.domain.CeilometerAlarm;
import com.huawei.openstack4j.openstack.telemetry.internal.BaseTelemetryServices;
import java.util.List;

public class AlarmServiceImpl
extends BaseTelemetryServices
implements AlarmService {
    @Override
    public List<? extends Alarm> list() {
        CeilometerAlarm[] alarms = this.get(CeilometerAlarm[].class, this.uri("/alarms", new Object[0])).execute();
        return this.wrapList(alarms);
    }

    @Override
    public Alarm getById(String alarmId) {
        Preconditions.checkNotNull((Object)alarmId);
        return this.get(CeilometerAlarm.class, this.uri("/alarms/%s", alarmId)).execute();
    }

    @Override
    public void update(String alarmId, Alarm alarm) {
        Preconditions.checkNotNull((Object)alarmId);
        Preconditions.checkNotNull((Object)alarm);
        this.put(CeilometerAlarm.class, this.uri("/alarms/%s", alarmId)).entity(alarm).execute();
    }

    @Override
    public Alarm create(Alarm alarm) {
        Preconditions.checkNotNull((Object)alarm);
        return this.post(CeilometerAlarm.class, this.uri("/alarms", new Object[0])).entity(alarm).execute();
    }

    @Override
    public ActionResponse delete(String alarmId) {
        Preconditions.checkNotNull((Object)alarmId);
        return this.deleteWithResponse(this.uri("/alarms/%s", alarmId)).execute();
    }
}

