/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.telemetry.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.telemetry.SampleService;
import com.huawei.openstack4j.model.telemetry.Sample;
import com.huawei.openstack4j.model.telemetry.SampleCriteria;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.telemetry.domain.CeiloMeterSample;
import com.huawei.openstack4j.openstack.telemetry.internal.BaseTelemetryServices;
import java.util.List;

public class SampleServiceImpl
extends BaseTelemetryServices
implements SampleService {
    private static final String FIELD = "q.field";
    private static final String OPER = "q.op";
    private static final String VALUE = "q.value";

    @Override
    public List<? extends Sample> list() {
        CeiloMeterSample[] samples = this.get(CeiloMeterSample[].class, this.uri("/samples", new Object[0])).execute();
        return this.wrapList(samples);
    }

    @Override
    public List<? extends Sample> list(SampleCriteria criteria) {
        BaseOpenStackService.Invocation<CeiloMeterSample[]> invocation = this.get(CeiloMeterSample[].class, this.uri("/samples", new Object[0]));
        if (criteria != null && !criteria.getCriteriaParams().isEmpty()) {
            for (SampleCriteria.NameOpValue c : criteria.getCriteriaParams()) {
                invocation.param(FIELD, c.getField());
                invocation.param(OPER, c.getOperator().getQueryValue());
                invocation.param(VALUE, c.getValue());
            }
        }
        CeiloMeterSample[] samples = invocation.execute();
        return this.wrapList(samples);
    }

    @Override
    public Sample get(String sampleId) {
        Preconditions.checkNotNull((Object)sampleId);
        CeiloMeterSample sample = this.get(CeiloMeterSample.class, this.uri("/samples/%s", sampleId)).execute();
        return sample;
    }
}

