/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.tms.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.tms.v1.contants.Action;
import com.huawei.openstack4j.openstack.tms.v1.domain.PredefineTagRequest;
import com.huawei.openstack4j.openstack.tms.v1.domain.PredefineTags;
import com.huawei.openstack4j.openstack.tms.v1.domain.PredefineTagsAction;
import com.huawei.openstack4j.openstack.tms.v1.internal.BaseTagManagementService;
import com.huawei.openstack4j.openstack.tms.v1.internal.TagFilterOption;
import java.util.HashMap;
import java.util.List;

public class TagService
extends BaseTagManagementService {
    public String create(List<PredefineTagRequest> tagList) {
        Preconditions.checkArgument((tagList.size() > 0 ? 1 : 0) != 0, (Object)"parameter `predefine_tag_request` should not be empty");
        PredefineTagsAction tagsAtion = PredefineTagsAction.builder().action(Action.Create).tagList(tagList).build();
        return this.post(String.class, this.uri("/predefine_tags/action", new Object[0])).entity(tagsAtion).execute();
    }

    public String delete(List<PredefineTagRequest> tagList) {
        Preconditions.checkArgument((tagList.size() > 0 ? 1 : 0) != 0, (Object)"parameter `predefine_tag_request` should not be empty");
        PredefineTagsAction tagsAtion = PredefineTagsAction.builder().action(Action.Delete).tagList(tagList).build();
        return this.post(String.class, this.uri("/predefine_tags/action", new Object[0])).entity(tagsAtion).execute();
    }

    public PredefineTags list() {
        return this.get(PredefineTags.class, this.uri("/predefine_tags", new Object[0])).execute();
    }

    public PredefineTags list(TagFilterOption option) {
        return this.get(PredefineTags.class, this.uri("/predefine_tags", new Object[0])).params(option.getOptions()).execute();
    }

    public ActionResponse modify(PredefineTagRequest oldTag, PredefineTagRequest newTag) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)oldTag.getKey()) ? 1 : 0) != 0, (Object)"parameter `oldTag.key` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)newTag.getKey()) ? 1 : 0) != 0, (Object)"parameter `newTag.key` should not be empty");
        HashMap<String, PredefineTagRequest> entity = new HashMap<String, PredefineTagRequest>();
        entity.put("new_tag", newTag);
        entity.put("old_tag", oldTag);
        return this.putWithResponse("/predefine_tags").entity(entity).execute();
    }
}

