/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.trove.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.trove.domain.Database;
import java.beans.ConstructorProperties;
import java.util.List;

public class DatabaseUser
implements ModelEntity {
    private static final long serialVersionUID = -3324036820846287512L;
    @JsonProperty(value="name")
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="databases")
    List<Database> databases;

    public static DatabaseUserBuilder builder() {
        return new DatabaseUserBuilder();
    }

    public DatabaseUserBuilder toBuilder() {
        return new DatabaseUserBuilder().username(this.username).password(this.password).databases(this.databases);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public String toString() {
        return "DatabaseUser(username=" + this.getUsername() + ", password=" + this.getPassword() + ", databases=" + this.getDatabases() + ")";
    }

    public DatabaseUser() {
    }

    @ConstructorProperties(value={"username", "password", "databases"})
    public DatabaseUser(String username, String password, List<Database> databases) {
        this.username = username;
        this.password = password;
        this.databases = databases;
    }

    public static class DatabaseUserBuilder {
        private String username;
        private String password;
        private List<Database> databases;

        DatabaseUserBuilder() {
        }

        public DatabaseUserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public DatabaseUserBuilder password(String password) {
            this.password = password;
            return this;
        }

        public DatabaseUserBuilder databases(List<Database> databases) {
            this.databases = databases;
            return this;
        }

        public DatabaseUser build() {
            return new DatabaseUser(this.username, this.password, this.databases);
        }

        public String toString() {
            return "DatabaseUser.DatabaseUserBuilder(username=" + this.username + ", password=" + this.password + ", databases=" + this.databases + ")";
        }
    }
}

