/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.trove.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseConfig;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseConfigCreate;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseConfigUpdate;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseInstance;
import com.huawei.openstack4j.openstack.trove.internal.BaseTroveServices;
import java.util.List;
import java.util.Map;

public class TroveDatabaseConfigService
extends BaseTroveServices {
    public DatabaseConfig create(DatabaseConfigCreate creation) {
        Preconditions.checkNotNull((Object)creation, (Object)"parameter `creation` should not be null");
        Preconditions.checkNotNull((Object)creation.getDatastore(), (Object)"parameter `creation.datastore` should not be null");
        Preconditions.checkArgument((!creation.getValues().isEmpty() && creation.getValues().size() > 0 ? 1 : 0) != 0, (Object)"parameter `creation.values` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getName()) ? 1 : 0) != 0, (Object)"parameter `creation.name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getDatastore().getVersion()) ? 1 : 0) != 0, (Object)"parameter `creation.datastore.version` should not be empty");
        Preconditions.checkArgument((creation.getDatastore().getType() != null ? 1 : 0) != 0, (Object)"parameter `creation.datastore.type` should not be empty");
        return this.post(DatabaseConfig.class, "/configurations").entity(creation).execute();
    }

    public ActionResponse update(DatabaseConfigUpdate update) {
        Preconditions.checkNotNull((Object)update, (Object)"parameter `update` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)update.getId()) ? 1 : 0) != 0, (Object)"parameter `update.id` should not be empty");
        return this.put(ActionResponse.class, "/configurations/", update.getId()).entity(update).execute();
    }

    public ActionResponse updateParams(String configurationId, Map<String, String> params) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configurationId) ? 1 : 0) != 0, (Object)"parameter `configurationId` should not be empty");
        Preconditions.checkArgument((params != null && !params.isEmpty() ? 1 : 0) != 0, (Object)"parameter `customerParams` should not be empty");
        DatabaseConfigUpdate build = DatabaseConfigUpdate.builder().values(params).build();
        return this.patch(ActionResponse.class, "/configurations/", configurationId).entity(build).execute();
    }

    public List<DatabaseConfig> list() {
        return this.get(DatabaseConfig.Configs.class, "/configurations").execute().getList();
    }

    public DatabaseConfig get(String configurationId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configurationId) ? 1 : 0) != 0, (Object)"parameter `configurationId` should not be empty");
        return this.get(DatabaseConfig.class, "/configurations/", configurationId).execute();
    }

    public ActionResponse delete(String configurationId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configurationId) ? 1 : 0) != 0, (Object)"parameter `configurationId` should not be empty");
        return this.deleteWithResponse("/configurations/", configurationId).execute();
    }

    public List<DatabaseInstance> listDatabaseInstances(String configurationId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configurationId) ? 1 : 0) != 0, (Object)"parameter `configurationId` should not be empty");
        return this.get(DatabaseInstance.DatabaseInstances.class, "/configurations/", configurationId, "/instances").execute().getList();
    }
}

