/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.trove.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.database.domain.Volume;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseInstance;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseInstanceCreate;
import com.huawei.openstack4j.openstack.trove.domain.DatabaseReplicaInstanceCreate;
import com.huawei.openstack4j.openstack.trove.internal.BaseTroveServices;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TroveDatabaseInstanceService
extends BaseTroveServices {
    public List<DatabaseInstance> list() {
        ArrayList result = Lists.newArrayList();
        List list = this.get(DatabaseInstance.DatabaseInstanceWraps.class, this.uri("/instances", new Object[0])).execute().getList();
        for (DatabaseInstance.DatabaseInstanceWrap wrap : list) {
            result.add(wrap.getInstance());
        }
        return result;
    }

    public DatabaseInstance get(String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        DatabaseInstance instance = this.get(DatabaseInstance.class, this.uri("/instances/%s", instanceId)).execute();
        return instance;
    }

    public DatabaseInstance create(DatabaseInstanceCreate creation) {
        Preconditions.checkNotNull((Object)creation, (Object)"parameter `creation` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getName()) ? 1 : 0) != 0, (Object)"parameter `creation.name` should not be empty");
        Preconditions.checkNotNull((Object)creation.getDatastore(), (Object)"parameter `creation.datastore` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getDatastore().getVersion()) ? 1 : 0) != 0, (Object)"parameter `creation.datastore.version` should not be empty");
        Preconditions.checkNotNull((Object)((Object)creation.getDatastore().getType()), (Object)"parameter `creation.datastore.type` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `creation.flavorRef` should not be empty");
        Preconditions.checkArgument((creation.getUsers() != null && creation.getUsers().size() > 0 ? 1 : 0) != 0, (Object)"parameter `creation.users` should not be empty");
        Preconditions.checkArgument((creation.getVolume() != null ? 1 : 0) != 0, (Object)"parameter `creation.volume` should not be null");
        Preconditions.checkArgument((creation.getVolume().getSize() != null ? 1 : 0) != 0, (Object)"parameter `creation.volume.size` should not be null");
        return this.post(DatabaseInstance.class, this.uri("/instances", new Object[0])).entity(creation).execute();
    }

    public DatabaseInstance createReplica(DatabaseReplicaInstanceCreate creation) {
        Preconditions.checkNotNull((Object)creation, (Object)"parameter `creation` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getName()) ? 1 : 0) != 0, (Object)"parameter `creation.name` should not be empty");
        Preconditions.checkNotNull((Object)creation.getDatastore(), (Object)"parameter `creation.datastore` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getDatastore().getVersion()) ? 1 : 0) != 0, (Object)"parameter `creation.datastore.version` should not be empty");
        Preconditions.checkNotNull((Object)((Object)creation.getDatastore().getType()), (Object)"parameter `creation.datastore.type` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `creation.flavorRef` should not be empty");
        Preconditions.checkArgument((creation.getVolume() != null ? 1 : 0) != 0, (Object)"parameter `creation.volume` should not be null");
        Preconditions.checkArgument((creation.getVolume().getSize() != null ? 1 : 0) != 0, (Object)"parameter `creation.volume.size` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getReplicaOf()) ? 1 : 0) != 0, (Object)"parameter `creation.replicaOf` should not be empty");
        return this.post(DatabaseInstance.class, this.uri("/instances", new Object[0])).entity(creation).execute();
    }

    public ActionResponse delete(String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        return this.deleteWithResponse(this.uri("/instances/%s", instanceId)).execute();
    }

    public ActionResponse restart(String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        HashMap entity = Maps.newHashMap();
        entity.put("restart", Maps.newHashMap());
        return this.postWithResponse(this.uri("/instances/%s/action", instanceId)).entity(entity).execute();
    }

    public ActionResponse resize(String instanceId, int volumeSize) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        Preconditions.checkArgument((volumeSize >= 110 && volumeSize <= 2000 ? 1 : 0) != 0, (Object)"parameter `volumeSize` shoule between 110 and 2000");
        ResizeVolumeRequest entity = new ResizeVolumeRequest();
        entity.setVolume(Volume.builder().size(volumeSize).build());
        return this.postWithResponse(this.uri("/instances/%s/action", instanceId)).entity(entity).execute();
    }

    public ActionResponse resize(String instanceId, String flavorRef) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)flavorRef) ? 1 : 0) != 0, (Object)"parameter `flavorRef` should not be empty");
        ResizeFlavorRequest entity = new ResizeFlavorRequest();
        entity.setFlavorRef(flavorRef);
        return this.postWithResponse(this.uri("/instances/%s/action", instanceId)).entity(entity).execute();
    }

    @JsonRootName(value="resize")
    class ResizeFlavorRequest {
        @JsonProperty(value="flavorRef")
        String flavorRef;

        ResizeFlavorRequest() {
        }

        public String getFlavorRef() {
            return this.flavorRef;
        }

        public void setFlavorRef(String flavorRef) {
            this.flavorRef = flavorRef;
        }
    }

    @JsonRootName(value="resize")
    class ResizeVolumeRequest {
        @JsonProperty(value="volume")
        Volume volume;

        ResizeVolumeRequest() {
        }

        public Volume getVolume() {
            return this.volume;
        }

        public void setVolume(Volume volume) {
            this.volume = volume;
        }
    }
}

