/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.vpc.v1.domain.AllowAddressPair;
import com.huawei.openstack4j.openstack.vpc.v1.domain.ExtraDhcpOpt;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="port")
public class PortUpdate
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="security_groups")
    private List<String> securityGroups;
    @JsonProperty(value="allowed_address_pairs")
    private List<AllowAddressPair> allowedAddressPairs;
    @JsonProperty(value="extra_dhcp_opts")
    private List<ExtraDhcpOpt> extraDhcpOpts;

    public static PortUpdateBuilder builder() {
        return new PortUpdateBuilder();
    }

    public PortUpdateBuilder toBuilder() {
        return new PortUpdateBuilder().name(this.name).securityGroups(this.securityGroups).allowedAddressPairs(this.allowedAddressPairs).extraDhcpOpts(this.extraDhcpOpts);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public List<AllowAddressPair> getAllowedAddressPairs() {
        return this.allowedAddressPairs;
    }

    public List<ExtraDhcpOpt> getExtraDhcpOpts() {
        return this.extraDhcpOpts;
    }

    public String toString() {
        return "PortUpdate(name=" + this.getName() + ", securityGroups=" + this.getSecurityGroups() + ", allowedAddressPairs=" + this.getAllowedAddressPairs() + ", extraDhcpOpts=" + this.getExtraDhcpOpts() + ")";
    }

    public PortUpdate() {
    }

    @ConstructorProperties(value={"name", "securityGroups", "allowedAddressPairs", "extraDhcpOpts"})
    public PortUpdate(String name, List<String> securityGroups, List<AllowAddressPair> allowedAddressPairs, List<ExtraDhcpOpt> extraDhcpOpts) {
        this.name = name;
        this.securityGroups = securityGroups;
        this.allowedAddressPairs = allowedAddressPairs;
        this.extraDhcpOpts = extraDhcpOpts;
    }

    public static class PortUpdateBuilder {
        private String name;
        private List<String> securityGroups;
        private List<AllowAddressPair> allowedAddressPairs;
        private List<ExtraDhcpOpt> extraDhcpOpts;

        PortUpdateBuilder() {
        }

        public PortUpdateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PortUpdateBuilder securityGroups(List<String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public PortUpdateBuilder allowedAddressPairs(List<AllowAddressPair> allowedAddressPairs) {
            this.allowedAddressPairs = allowedAddressPairs;
            return this;
        }

        public PortUpdateBuilder extraDhcpOpts(List<ExtraDhcpOpt> extraDhcpOpts) {
            this.extraDhcpOpts = extraDhcpOpts;
            return this;
        }

        public PortUpdate build() {
            return new PortUpdate(this.name, this.securityGroups, this.allowedAddressPairs, this.extraDhcpOpts);
        }

        public String toString() {
            return "PortUpdate.PortUpdateBuilder(name=" + this.name + ", securityGroups=" + this.securityGroups + ", allowedAddressPairs=" + this.allowedAddressPairs + ", extraDhcpOpts=" + this.extraDhcpOpts + ")";
        }
    }
}

