/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="resource")
public class Resource
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    private String type;
    private Integer used;
    private Integer quota;
    private Integer min;

    public static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    public ResourceBuilder toBuilder() {
        return new ResourceBuilder().type(this.type).used(this.used).quota(this.quota).min(this.min);
    }

    public String getType() {
        return this.type;
    }

    public Integer getUsed() {
        return this.used;
    }

    public Integer getQuota() {
        return this.quota;
    }

    public Integer getMin() {
        return this.min;
    }

    public String toString() {
        return "Resource(type=" + this.getType() + ", used=" + this.getUsed() + ", quota=" + this.getQuota() + ", min=" + this.getMin() + ")";
    }

    public Resource() {
    }

    @ConstructorProperties(value={"type", "used", "quota", "min"})
    public Resource(String type, Integer used, Integer quota, Integer min) {
        this.type = type;
        this.used = used;
        this.quota = quota;
        this.min = min;
    }

    public static class ResourceBuilder {
        private String type;
        private Integer used;
        private Integer quota;
        private Integer min;

        ResourceBuilder() {
        }

        public ResourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ResourceBuilder used(Integer used) {
            this.used = used;
            return this;
        }

        public ResourceBuilder quota(Integer quota) {
            this.quota = quota;
            return this;
        }

        public ResourceBuilder min(Integer min) {
            this.min = min;
            return this;
        }

        public Resource build() {
            return new Resource(this.type, this.used, this.quota, this.min);
        }

        public String toString() {
            return "Resource.ResourceBuilder(type=" + this.type + ", used=" + this.used + ", quota=" + this.quota + ", min=" + this.min + ")";
        }
    }

    @JsonRootName(value="quotas")
    public static class Quotas
    extends ListResult<Resource> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="resources")
        private List<Resource> resources;

        @Override
        public List<Resource> value() {
            return this.resources;
        }
    }
}

