/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SecurityGroupRule;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="security_group")
public class SecurityGroup
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    @JsonProperty(value="vpc_id")
    private String vpcId;
    @JsonProperty(value="security_group_rules")
    private List<SecurityGroupRule> securityGroupRules;
    @JsonProperty(value="enterprise_project_id")
    private String enterpriseProjectId;

    public static SecurityGroupBuilder builder() {
        return new SecurityGroupBuilder();
    }

    public SecurityGroupBuilder toBuilder() {
        return new SecurityGroupBuilder().id(this.id).name(this.name).description(this.description).vpcId(this.vpcId).securityGroupRules(this.securityGroupRules).enterpriseProjectId(this.enterpriseProjectId);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public List<SecurityGroupRule> getSecurityGroupRules() {
        return this.securityGroupRules;
    }

    public String getEnterpriseProjectId() {
        return this.enterpriseProjectId;
    }

    public String toString() {
        return "SecurityGroup(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", vpcId=" + this.getVpcId() + ", securityGroupRules=" + this.getSecurityGroupRules() + ", enterpriseProjectId=" + this.getEnterpriseProjectId() + ")";
    }

    public SecurityGroup() {
    }

    @ConstructorProperties(value={"id", "name", "description", "vpcId", "securityGroupRules", "enterpriseProjectId"})
    public SecurityGroup(String id, String name, String description, String vpcId, List<SecurityGroupRule> securityGroupRules, String enterpriseProjectId) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.vpcId = vpcId;
        this.securityGroupRules = securityGroupRules;
        this.enterpriseProjectId = enterpriseProjectId;
    }

    public static class SecurityGroupBuilder {
        private String id;
        private String name;
        private String description;
        private String vpcId;
        private List<SecurityGroupRule> securityGroupRules;
        private String enterpriseProjectId;

        SecurityGroupBuilder() {
        }

        public SecurityGroupBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SecurityGroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SecurityGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SecurityGroupBuilder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public SecurityGroupBuilder securityGroupRules(List<SecurityGroupRule> securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
            return this;
        }

        public SecurityGroupBuilder enterpriseProjectId(String enterpriseProjectId) {
            this.enterpriseProjectId = enterpriseProjectId;
            return this;
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.id, this.name, this.description, this.vpcId, this.securityGroupRules, this.enterpriseProjectId);
        }

        public String toString() {
            return "SecurityGroup.SecurityGroupBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", vpcId=" + this.vpcId + ", securityGroupRules=" + this.securityGroupRules + ", enterpriseProjectId=" + this.enterpriseProjectId + ")";
        }
    }

    public static class SecurityGroups
    extends ListResult<SecurityGroup> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="security_groups")
        private List<SecurityGroup> securityGroups;

        @Override
        public List<SecurityGroup> value() {
            return this.securityGroups;
        }
    }
}

