/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.vpc.v1.domain.VirtualBandWidthUpdate;
import com.huawei.openstack4j.openstack.vpc.v1.domain.VirtualBandWidths;
import com.huawei.openstack4j.openstack.vpc.v1.internal.BaseVirtualPrivateCloudService;
import java.util.List;
import java.util.Map;

public class BandWidthService
extends BaseVirtualPrivateCloudService {
    public List<VirtualBandWidths> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<VirtualBandWidths.VirtualBandWidthResps> serverInvocation = this.get(VirtualBandWidths.VirtualBandWidthResps.class, "/bandwidths");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                serverInvocation = serverInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return serverInvocation.execute().getList();
    }

    public List<VirtualBandWidths> list() {
        return this.get(VirtualBandWidths.VirtualBandWidthResps.class, "/bandwidths").execute().getList();
    }

    public VirtualBandWidths get(String bandwidthId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bandwidthId) ? 1 : 0) != 0, (Object)"parameter `bandwidthId` should not be empty");
        return this.get(VirtualBandWidths.class, "/bandwidths/" + bandwidthId).execute();
    }

    public VirtualBandWidths update(VirtualBandWidthUpdate bandWidtUpdate, String bandwidthId) {
        Preconditions.checkArgument((null != bandWidtUpdate ? 1 : 0) != 0, (Object)"parameter `bandWidtUpdate` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bandwidthId) ? 1 : 0) != 0, (Object)"parameter `bandwidthId` should not be empty");
        return this.put(VirtualBandWidths.class, "/bandwidths/" + bandwidthId).entity(bandWidtUpdate).execute();
    }
}

