/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.vpc.v1.domain.PublicIp;
import com.huawei.openstack4j.openstack.vpc.v1.domain.PublicIpUpdate;
import com.huawei.openstack4j.openstack.vpc.v1.domain.VirtualPublicIp;
import com.huawei.openstack4j.openstack.vpc.v1.domain.VirtualPublicIps;
import com.huawei.openstack4j.openstack.vpc.v1.domain.VirtualPublicIpsResp;
import com.huawei.openstack4j.openstack.vpc.v1.internal.BaseVirtualPrivateCloudService;
import java.util.List;
import java.util.Map;

public class PublicIpService
extends BaseVirtualPrivateCloudService {
    public List<? extends PublicIp> list() {
        return this.list(null);
    }

    public List<? extends PublicIp> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<PublicIp.Publicips> flavorInvocation = this.get(PublicIp.Publicips.class, this.uri("/publicips", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    public VirtualPublicIpsResp apply(VirtualPublicIps virtualPublicIps) {
        Preconditions.checkNotNull((Object)virtualPublicIps, (Object)"parameter `virtualPublicIps` should not be null");
        Preconditions.checkNotNull((Object)virtualPublicIps.getVirtualPublicIp(), (Object)"parameter `publicip` should not be null");
        Preconditions.checkNotNull((Object)virtualPublicIps.getVirtualBandwidth(), (Object)"parameter `bandwidth` should not be null");
        Preconditions.checkArgument((null != virtualPublicIps.getVirtualPublicIp().getType() ? 1 : 0) != 0, (Object)"parameter `type` should not be empty");
        Preconditions.checkArgument((null != virtualPublicIps.getVirtualBandwidth().getShareType() ? 1 : 0) != 0, (Object)"parameter `share_type` should not be empty");
        return this.post(VirtualPublicIpsResp.class, "/publicips").entity(virtualPublicIps).execute();
    }

    public VirtualPublicIp get(String publicipId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)publicipId) ? 1 : 0) != 0, (Object)"parameter `publicipId` should not be empty");
        return this.get(VirtualPublicIp.class, "/publicips/" + publicipId).execute();
    }

    public PublicIp update(String publicIpId, PublicIpUpdate publicIpUpdate) {
        Preconditions.checkNotNull((Object)publicIpUpdate, (Object)"parameter `publicIpUpdate` should not be null");
        Preconditions.checkNotNull((Object)publicIpId, (Object)"parameter `publicIpId` should not be null");
        return this.put(PublicIp.class, this.uri("/publicips/%s", publicIpId)).entity(publicIpUpdate).execute();
    }

    public ActionResponse delete(String publicIpId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)publicIpId) ? 1 : 0) != 0, (Object)"parameter `publicipId` should not be empty");
        return this.deleteWithResponse(this.uri("/publicips/%s", publicIpId)).execute();
    }
}

