/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Subnet;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SubnetCreate;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SubnetUpdate;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SubnetUpdateResp;
import com.huawei.openstack4j.openstack.vpc.v1.internal.BaseVirtualPrivateCloudService;
import java.util.List;
import java.util.Map;

public class SubnetService
extends BaseVirtualPrivateCloudService {
    public List<? extends Subnet> list() {
        return this.list(null);
    }

    public List<? extends Subnet> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<Subnet.Subnets> flavorInvocation = this.get(Subnet.Subnets.class, this.uri("/subnets", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    public Subnet create(SubnetCreate subnetCreate) {
        Preconditions.checkNotNull((Object)subnetCreate, (Object)"parameter `subnetCreate` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subnetCreate.getName()) ? 1 : 0) != 0, (Object)"parameter `subnetCreate.name` should not be empty");
        Preconditions.checkNotNull((Object)subnetCreate.getCidr(), (Object)"parameter `subnetCreate.cidr` should not be empty");
        Preconditions.checkNotNull((Object)subnetCreate.getGatewayIp(), (Object)"parameter `subnetCreate.gatewayIp` should not be empty");
        Preconditions.checkNotNull((Object)subnetCreate.getVpcId(), (Object)"parameter `subnetCreate.vpcId` should not be empty");
        return this.post(Subnet.class, this.uri("/subnets", new Object[0])).entity(subnetCreate).execute();
    }

    public Subnet get(String subnetId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subnetId) ? 1 : 0) != 0, (Object)"parameter `subnetId` should not be empty");
        return this.get(Subnet.class, this.uri("/subnets/%s", subnetId)).execute();
    }

    public SubnetUpdateResp update(String vpcId, String subnetId, SubnetUpdate subnetUpdate) {
        Preconditions.checkNotNull((Object)subnetUpdate, (Object)"parameter `subnetUpdate` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)vpcId) ? 1 : 0) != 0, (Object)"parameter `subnet.vpcId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subnetId) ? 1 : 0) != 0, (Object)"parameter `subnet.id` should not be empty");
        Preconditions.checkNotNull((Object)subnetUpdate.getName(), (Object)"parameter `subnet.name` should not be empty");
        return this.put(SubnetUpdateResp.class, this.uri("/vpcs/%s/subnets/%s", vpcId, subnetId)).entity(subnetUpdate).execute();
    }

    public ActionResponse delete(String vpcId, String subnetId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)vpcId) ? 1 : 0) != 0, (Object)"parameter `vpcId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subnetId) ? 1 : 0) != 0, (Object)"parameter `subnetId` should not be empty");
        return this.deleteWithResponse(this.uri("/vpcs/%s/subnets/%s", vpcId, subnetId)).execute();
    }
}

