/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Vpc;
import com.huawei.openstack4j.openstack.vpc.v1.domain.VpcCreate;
import com.huawei.openstack4j.openstack.vpc.v1.domain.VpcUpdate;
import com.huawei.openstack4j.openstack.vpc.v1.internal.BaseVirtualPrivateCloudService;
import java.util.List;
import java.util.Map;

public class VpcService
extends BaseVirtualPrivateCloudService {
    public List<? extends Vpc> list() {
        return this.list(null);
    }

    public List<? extends Vpc> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<Vpc.Vpcs> flavorInvocation = this.get(Vpc.Vpcs.class, this.uri("/vpcs", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    public Vpc create(VpcCreate vpcCreate) {
        Preconditions.checkNotNull((Object)vpcCreate, (Object)"parameter `vpcCreate` should not be null");
        return this.post(Vpc.class, this.uri("/vpcs", new Object[0])).entity(vpcCreate).execute();
    }

    public Vpc get(String vpcId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)vpcId) ? 1 : 0) != 0, (Object)"parameter `vpcId` should not be empty");
        return this.get(Vpc.class, this.uri("/vpcs/%s", vpcId)).execute();
    }

    public Vpc update(String vpcId, VpcUpdate vpcUpdate) {
        Preconditions.checkNotNull((Object)vpcUpdate, (Object)"parameter `vpcUpdate` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)vpcId) ? 1 : 0) != 0, (Object)"parameter `vpcId` should not be empty");
        return this.put(Vpc.class, this.uri("/vpcs/%s", vpcId)).entity(vpcUpdate).execute();
    }

    public ActionResponse delete(String vpcId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)vpcId) ? 1 : 0) != 0, (Object)"parameter `vpcId` should not be empty");
        return this.deleteWithResponse(this.uri("/vpcs/%s", vpcId)).execute();
    }
}

