/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.vpc.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.common.functions.RemoveProjectIdFromURL;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.vpc.v2.domain.Route;
import java.util.List;
import java.util.Map;

public class RouteService
extends BaseOpenStackService {
    public RouteService() {
        super(ServiceType.VPC2, RemoveProjectIdFromURL.INSTANCE);
    }

    public List<Route> list() {
        return this.list(null);
    }

    public List<Route> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<Route.Routes> req = this.get(Route.Routes.class, this.uri("/vpc/routes", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    public Route get(String routeId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)routeId) ? 1 : 0) != 0, (Object)"parameter `routeId` should not be empty");
        return this.get(Route.class, this.uri("/vpc/routes/%s", routeId)).execute();
    }

    public Route create(Route routeCreate) {
        Preconditions.checkArgument((routeCreate != null ? 1 : 0) != 0, (Object)"parameter `routeCreate` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)routeCreate.getDestination()) ? 1 : 0) != 0, (Object)"parameter `routeCreate.destination` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)routeCreate.getNexthop()) ? 1 : 0) != 0, (Object)"parameter `routeCreate.nexthop` should not be empty");
        Preconditions.checkArgument((routeCreate.getType() != null ? 1 : 0) != 0, (Object)"parameter `routeCreate.type` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)routeCreate.getVpcId()) ? 1 : 0) != 0, (Object)"parameter `routeCreate.vpcId` should not be empty");
        return this.post(Route.class, this.uri("/vpc/routes", new Object[0])).entity(routeCreate).execute();
    }

    public ActionResponse delete(String routeId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)routeId) ? 1 : 0) != 0, (Object)"parameter `routeId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vpc/routes/%s", routeId)).executeWithResponse());
    }
}

