/*
 * Decompiled with CFR 0.152.
 */
package com.hubject.aws.s3.io;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import com.hubject.aws.s3.io.Md5Kt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010.\u001a\u00020\u000eH\u0016J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e0&J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e0&2\u0006\u00101\u001a\u00020*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u001a\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010'\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0011\u00a8\u00062"}, d2={"Lcom/hubject/aws/s3/io/S3MultipartUploader;", "Ljava/lang/AutoCloseable;", "awsS3", "Lcom/amazonaws/services/s3/AmazonS3;", "targetBucket", "", "targetS3Key", "useChecksums", "", "(Lcom/amazonaws/services/s3/AmazonS3;Ljava/lang/String;Ljava/lang/String;Z)V", "getAwsS3", "()Lcom/amazonaws/services/s3/AmazonS3;", "completionFuture", "Ljava/util/concurrent/CompletableFuture;", "", "<set-?>", "isClosed", "()Z", "setClosed", "(Z)V", "isClosedMutex", "", "multipartInitResponse", "Lcom/amazonaws/services/s3/model/InitiateMultipartUploadResult;", "getMultipartInitResponse", "()Lcom/amazonaws/services/s3/model/InitiateMultipartUploadResult;", "multipartInitResponse$delegate", "Lkotlin/Lazy;", "multipartUploadHasBeenStarted", "nPartsUploaded", "", "getNPartsUploaded", "()I", "getTargetBucket", "()Ljava/lang/String;", "getTargetS3Key", "uploadFutures", "", "Ljava/util/concurrent/Future;", "uploadQueue", "Ljava/util/concurrent/BlockingQueue;", "Lkotlin/Pair;", "Ljava/nio/ByteBuffer;", "uploadingThread", "Ljava/lang/Thread;", "getUseChecksums", "close", "complete", "queuePart", "partData", "aws-s3-io"})
public final class S3MultipartUploader
implements AutoCloseable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private boolean multipartUploadHasBeenStarted;
    private final Lazy multipartInitResponse$delegate;
    private final BlockingQueue<Pair<ByteBuffer, CompletableFuture<Unit>>> uploadQueue;
    private final Thread uploadingThread;
    private final List<Future<Unit>> uploadFutures;
    private final CompletableFuture<Unit> completionFuture;
    private boolean isClosed;
    private final Object isClosedMutex;
    @NotNull
    private final AmazonS3 awsS3;
    @NotNull
    private final String targetBucket;
    @NotNull
    private final String targetS3Key;
    private final boolean useChecksums;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(S3MultipartUploader.class), "multipartInitResponse", "getMultipartInitResponse()Lcom/amazonaws/services/s3/model/InitiateMultipartUploadResult;"))};
    }

    private final InitiateMultipartUploadResult getMultipartInitResponse() {
        Lazy lazy = this.multipartInitResponse$delegate;
        S3MultipartUploader s3MultipartUploader = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (InitiateMultipartUploadResult)lazy.getValue();
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    private final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    public final int getNPartsUploaded() {
        return this.uploadFutures.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Future<Unit> queuePart(@NotNull ByteBuffer partData) {
        Intrinsics.checkParameterIsNotNull((Object)partData, (String)"partData");
        if (this.isClosed) {
            throw (Throwable)new IllegalStateException("Upload already closed / during completion");
        }
        CompletableFuture future = new CompletableFuture();
        this.uploadQueue.put((Pair<ByteBuffer, CompletableFuture<Unit>>)new Pair((Object)partData, future));
        List<Future<Unit>> list = this.uploadFutures;
        synchronized (list) {
            boolean bl = this.uploadFutures.add(future);
        }
        if (!this.uploadingThread.isAlive()) {
            try {
                this.uploadingThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Future<Unit> complete() {
        Object object = this.isClosedMutex;
        synchronized (object) {
            if (this.isClosed) {
                throw (Throwable)new IllegalStateException("Upload already closed / during completion");
            }
            this.isClosed = true;
            Unit unit = Unit.INSTANCE;
        }
        if (this.uploadFutures.isEmpty()) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(Unit)");
            return completableFuture;
        }
        CompletableFuture future = new CompletableFuture();
        ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)("multipart upload completion s3://" + this.targetBucket + '/' + this.targetS3Key), (int)0, (Function0)((Function0)new Function0<Unit>(this, future){
            final /* synthetic */ S3MultipartUploader this$0;
            final /* synthetic */ CompletableFuture $future;

            public final void invoke() {
                Iterable $receiver$iv = S3MultipartUploader.access$getUploadFutures$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    Future it = (Future)element$iv;
                    it.get();
                }
                S3MultipartUploader.access$getUploadingThread$p(this.this$0).interrupt();
                try {
                    this.$future.complete(S3MultipartUploader.access$getCompletionFuture$p(this.this$0).get());
                }
                catch (Throwable ex) {
                    this.$future.completeExceptionally(ex);
                }
            }
            {
                this.this$0 = s3MultipartUploader;
                this.$future = completableFuture;
                super(0);
            }
        }), (int)22, null);
        return future;
    }

    @Override
    public void close() {
        this.complete().get();
    }

    @NotNull
    public final AmazonS3 getAwsS3() {
        return this.awsS3;
    }

    @NotNull
    public final String getTargetBucket() {
        return this.targetBucket;
    }

    @NotNull
    public final String getTargetS3Key() {
        return this.targetS3Key;
    }

    public final boolean getUseChecksums() {
        return this.useChecksums;
    }

    public S3MultipartUploader(@NotNull AmazonS3 awsS3, @NotNull String targetBucket, @NotNull String targetS3Key, boolean useChecksums) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)awsS3, (String)"awsS3");
        Intrinsics.checkParameterIsNotNull((Object)targetBucket, (String)"targetBucket");
        Intrinsics.checkParameterIsNotNull((Object)targetS3Key, (String)"targetS3Key");
        this.awsS3 = awsS3;
        this.targetBucket = targetBucket;
        this.targetS3Key = targetS3Key;
        this.useChecksums = useChecksums;
        this.multipartInitResponse$delegate = LazyKt.lazy((Function0)((Function0)new Function0<InitiateMultipartUploadResult>(this){
            final /* synthetic */ S3MultipartUploader this$0;

            /*
             * WARNING - void declaration
             */
            public final InitiateMultipartUploadResult invoke() {
                void var1_1;
                InitiateMultipartUploadResult r = this.this$0.getAwsS3().initiateMultipartUpload(new InitiateMultipartUploadRequest(this.this$0.getTargetBucket(), this.this$0.getTargetS3Key()));
                S3MultipartUploader.access$setMultipartUploadHasBeenStarted$p(this.this$0, true);
                return var1_1;
            }
            {
                this.this$0 = s3MultipartUploader;
                super(0);
            }
        }));
        this.uploadQueue = new LinkedBlockingQueue(10);
        this.uploadingThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)("S3 multipart uploader s3://" + this.targetBucket + '/' + this.targetS3Key), (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ S3MultipartUploader this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                Object partFuture;
                int partNumber = 1;
                List uploadedPartsETags = new ArrayList<E>();
                while (true) {
                    Pair pair;
                    try {
                        pair = (Pair)S3MultipartUploader.access$getUploadQueue$p(this.this$0).take();
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                    Pair pair2 = pair;
                    ByteBuffer byteBuffer = (ByteBuffer)pair2.component1();
                    partFuture = (CompletableFuture)pair2.component2();
                    try {
                        void partData;
                        long partSize = partData.remaining();
                        ObjectMetadata metadata = new ObjectMetadata();
                        metadata.setContentLength(partSize);
                        if (this.this$0.getUseChecksums()) {
                            metadata.setContentMD5(Md5Kt.toBase64(Md5Kt.calculateMD5((ByteBuffer)partData)));
                        }
                        Closeable closeable = (Closeable)new ByteBufferBackedInputStream((ByteBuffer)partData);
                        Throwable throwable = null;
                        try {
                            UploadPartResult partUploadResult;
                            ByteBufferBackedInputStream uploadInputStream = (ByteBufferBackedInputStream)closeable;
                            UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(this.this$0.getTargetBucket()).withKey(this.this$0.getTargetS3Key()).withUploadId(S3MultipartUploader.access$getMultipartInitResponse$p(this.this$0).getUploadId()).withFileOffset(0L).withPartSize(partSize).withPartNumber(partNumber).withInputStream((InputStream)uploadInputStream).withObjectMetadata(metadata).withMD5Digest(metadata.getContentMD5());
                            UploadPartResult uploadPartResult = partUploadResult = this.this$0.getAwsS3().uploadPart(uploadRequest);
                            Intrinsics.checkExpressionValueIsNotNull((Object)uploadPartResult, (String)"partUploadResult");
                            PartETag partETag = uploadPartResult.getPartETag();
                            Intrinsics.checkExpressionValueIsNotNull((Object)partETag, (String)"partUploadResult.partETag");
                            boolean bl = uploadedPartsETags.add(partETag);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        ((CompletableFuture)partFuture).complete(Unit.INSTANCE);
                        int n = partNumber;
                        partNumber = n + 1;
                    }
                    catch (Throwable ex) {
                        if (partNumber > 1) {
                            try {
                                this.this$0.getAwsS3().abortMultipartUpload(new AbortMultipartUploadRequest(S3MultipartUploader.access$getMultipartInitResponse$p(this.this$0).getBucketName(), S3MultipartUploader.access$getMultipartInitResponse$p(this.this$0).getKey(), S3MultipartUploader.access$getMultipartInitResponse$p(this.this$0).getUploadId()));
                            }
                            catch (Throwable ex2) {
                                ex.addSuppressed(ex2);
                            }
                        }
                        ((CompletableFuture)partFuture).completeExceptionally(ex);
                        return;
                    }
                }
                if (partNumber > 1) {
                    try {
                        void $receiver$iv;
                        CompleteMultipartUploadRequest completeMultipartUploadRequest;
                        partFuture = uploadedPartsETags;
                        String string = S3MultipartUploader.access$getMultipartInitResponse$p(this.this$0).getUploadId();
                        String string2 = this.this$0.getTargetS3Key();
                        String string3 = this.this$0.getTargetBucket();
                        CompleteMultipartUploadRequest completeMultipartUploadRequest2 = completeMultipartUploadRequest;
                        CompleteMultipartUploadRequest completeMultipartUploadRequest3 = completeMultipartUploadRequest;
                        AmazonS3 amazonS3 = this.this$0.getAwsS3();
                        List list = CollectionsKt.sortedWith((Iterable)$receiver$iv, (Comparator)new Comparator<T>(){

                            public final int compare(T a, T b) {
                                PartETag it = (PartETag)a;
                                Comparable comparable = Integer.valueOf(it.getPartNumber());
                                it = (PartETag)b;
                                Comparable comparable2 = comparable;
                                Integer n = it.getPartNumber();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                            }
                        });
                        completeMultipartUploadRequest2(string3, string2, string, list);
                        CompleteMultipartUploadResult completionResult = amazonS3.completeMultipartUpload(completeMultipartUploadRequest3);
                        S3MultipartUploader.access$getCompletionFuture$p(this.this$0).complete(Unit.INSTANCE);
                    }
                    catch (Throwable ex) {
                        S3MultipartUploader.access$getCompletionFuture$p(this.this$0).completeExceptionally(ex);
                    }
                }
            }
            {
                this.this$0 = s3MultipartUploader;
                super(0);
            }
        }), (int)22, null);
        S3MultipartUploader s3MultipartUploader = this;
        s3MultipartUploader.uploadFutures = list = (List)new ArrayList();
        this.completionFuture = new CompletableFuture();
        this.isClosedMutex = new Object();
    }

    public /* synthetic */ S3MultipartUploader(AmazonS3 amazonS3, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(amazonS3, string, string2, bl);
    }

    @NotNull
    public static final /* synthetic */ List access$getUploadFutures$p(S3MultipartUploader $this) {
        return $this.uploadFutures;
    }

    @NotNull
    public static final /* synthetic */ Thread access$getUploadingThread$p(S3MultipartUploader $this) {
        return $this.uploadingThread;
    }

    @NotNull
    public static final /* synthetic */ CompletableFuture access$getCompletionFuture$p(S3MultipartUploader $this) {
        return $this.completionFuture;
    }

    public static final /* synthetic */ boolean access$getMultipartUploadHasBeenStarted$p(S3MultipartUploader $this) {
        return $this.multipartUploadHasBeenStarted;
    }

    public static final /* synthetic */ void access$setMultipartUploadHasBeenStarted$p(S3MultipartUploader $this, boolean bl) {
        $this.multipartUploadHasBeenStarted = bl;
    }

    @NotNull
    public static final /* synthetic */ BlockingQueue access$getUploadQueue$p(S3MultipartUploader $this) {
        return $this.uploadQueue;
    }

    @NotNull
    public static final /* synthetic */ InitiateMultipartUploadResult access$getMultipartInitResponse$p(S3MultipartUploader $this) {
        return $this.getMultipartInitResponse();
    }
}

