/*
 * Decompiled with CFR 0.152.
 */
package com.hubject.aws.s3.io;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import com.hubject.aws.s3.io.ByteBufferPool;
import com.hubject.aws.s3.io.Md5Kt;
import com.hubject.aws.s3.io.S3MultipartUploader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010&\u001a\u00020\u0017H\u0016J\b\u0010'\u001a\u00020\u0017H\u0016J\u0012\u0010(\u001a\u00020\u00172\b\b\u0002\u0010)\u001a\u00020\nH\u0002J\b\u0010*\u001a\u00020\u0017H\u0002J\"\u0010+\u001a\u00020\u00172\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020/H\u0016R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/hubject/aws/s3/io/S3OutputStream;", "Ljava/io/OutputStream;", "awsS3", "Lcom/amazonaws/services/s3/AmazonS3;", "targetBucket", "", "targetS3Key", "maxLocalCache", "", "useChecksums", "", "byteBufferPool", "Lcom/hubject/aws/s3/io/ByteBufferPool;", "(Lcom/amazonaws/services/s3/AmazonS3;Ljava/lang/String;Ljava/lang/String;JZLcom/hubject/aws/s3/io/ByteBufferPool;)V", "actualLocalCache", "getActualLocalCache", "()J", "getAwsS3", "()Lcom/amazonaws/services/s3/AmazonS3;", "isClosed", "getMaxLocalCache", "mostRecentUploadHandle", "Ljava/util/concurrent/Future;", "", "getTargetBucket", "()Ljava/lang/String;", "getTargetS3Key", "uploadBuffer", "Ljava/nio/ByteBuffer;", "uploader", "Lcom/hubject/aws/s3/io/S3MultipartUploader;", "getUploader", "()Lcom/hubject/aws/s3/io/S3MultipartUploader;", "uploader$delegate", "Lkotlin/Lazy;", "getUseChecksums", "()Z", "writeBuffer", "close", "flush", "uploadCurrentBufferAndSwitch", "isLastPart", "waitForCurrentUploadToFinish", "write", "b", "", "off", "", "len", "Companion", "aws-s3-io"})
public final class S3OutputStream
extends OutputStream {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final long actualLocalCache;
    private ByteBufferPool byteBufferPool;
    private ByteBuffer writeBuffer;
    private ByteBuffer uploadBuffer;
    private final Lazy uploader$delegate;
    private Future<Unit> mostRecentUploadHandle;
    private boolean isClosed;
    @NotNull
    private final AmazonS3 awsS3;
    @NotNull
    private final String targetBucket;
    @NotNull
    private final String targetS3Key;
    private final long maxLocalCache;
    private final boolean useChecksums;
    public static final int MIN_UPLOAD_PART_SIZE = 0x500000;
    public static final long MAX_UPLOAD_PART_SIZE = 0x140000000L;
    public static final long MAX_SINGLE_FILE_UPLOAD_SIZE = 0x140000000L;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(S3OutputStream.class), "uploader", "getUploader()Lcom/hubject/aws/s3/io/S3MultipartUploader;"))};
        Companion = new Companion(null);
    }

    public final long getActualLocalCache() {
        return this.actualLocalCache;
    }

    private final S3MultipartUploader getUploader() {
        Lazy lazy = this.uploader$delegate;
        S3OutputStream s3OutputStream = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (S3MultipartUploader)lazy.getValue();
    }

    @Override
    public void write(int b) {
        if (this.isClosed) {
            throw (Throwable)new IOException("Stream already closed.");
        }
        ByteBuffer byteBuffer = this.writeBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        if (!byteBuffer.hasRemaining()) {
            S3OutputStream.uploadCurrentBufferAndSwitch$default(this, false, 1, null);
        }
        ByteBuffer byteBuffer2 = this.writeBuffer;
        if (byteBuffer2 == null) {
            Intrinsics.throwNpe();
        }
        byteBuffer2.put((byte)b);
    }

    @Override
    public void write(@Nullable byte[] b, int off, int len) {
        if (this.isClosed) {
            throw (Throwable)new IOException("Stream already closed.");
        }
        ByteBuffer byteBuffer = this.writeBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        if (!byteBuffer.hasRemaining()) {
            S3OutputStream.uploadCurrentBufferAndSwitch$default(this, false, 1, null);
        }
        ByteBuffer byteBuffer2 = this.writeBuffer;
        if (byteBuffer2 == null) {
            Intrinsics.throwNpe();
        }
        if (len > byteBuffer2.remaining()) {
            ByteBuffer byteBuffer3 = this.writeBuffer;
            if (byteBuffer3 == null) {
                Intrinsics.throwNpe();
            }
            int nBytes = byteBuffer3.remaining();
            this.write(b, off, nBytes);
            this.write(b, off + nBytes, len - nBytes);
            return;
        }
        ByteBuffer byteBuffer4 = this.writeBuffer;
        if (byteBuffer4 == null) {
            Intrinsics.throwNpe();
        }
        byteBuffer4.put(b, off, len);
    }

    @Override
    public void flush() {
        if (this.isClosed) {
            throw (Throwable)new IllegalStateException("Stream already closed.");
        }
        ByteBuffer byteBuffer = this.writeBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        if (byteBuffer.position() >= 0x500000) {
            S3OutputStream.uploadCurrentBufferAndSwitch$default(this, false, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.waitForCurrentUploadToFinish();
        ByteBuffer byteBuffer = this.writeBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        long nBytesRemaining = byteBuffer.position();
        if (this.getUploader().getNPartsUploaded() > 0 || nBytesRemaining > 0x140000000L) {
            if (nBytesRemaining > 0L) {
                this.uploadCurrentBufferAndSwitch(true);
                this.waitForCurrentUploadToFinish();
            }
            this.getUploader().complete();
        } else {
            ByteBuffer byteBuffer2 = this.writeBuffer;
            if (byteBuffer2 == null) {
                Intrinsics.throwNpe();
            }
            byteBuffer2.flip();
            ObjectMetadata metadata = new ObjectMetadata();
            ByteBuffer byteBuffer3 = this.writeBuffer;
            if (byteBuffer3 == null) {
                Intrinsics.throwNpe();
            }
            metadata.setContentLength((long)byteBuffer3.remaining());
            if (this.useChecksums) {
                ByteBuffer byteBuffer4 = this.writeBuffer;
                if (byteBuffer4 == null) {
                    Intrinsics.throwNpe();
                }
                metadata.setContentMD5(Md5Kt.toBase64(Md5Kt.calculateMD5(byteBuffer4)));
            }
            Closeable closeable = (Closeable)new ByteBufferBackedInputStream(this.writeBuffer);
            Throwable throwable = null;
            try {
                ByteBufferBackedInputStream uploadInputStream = (ByteBufferBackedInputStream)closeable;
                PutObjectResult putObjectResult = this.awsS3.putObject(this.targetBucket, this.targetS3Key, (InputStream)uploadInputStream, metadata);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        ByteBufferPool byteBufferPool = this.byteBufferPool;
        if (byteBufferPool == null) {
            Intrinsics.throwNpe();
        }
        ByteBuffer byteBuffer5 = this.writeBuffer;
        if (byteBuffer5 == null) {
            Intrinsics.throwNpe();
        }
        byteBufferPool.free(byteBuffer5);
        this.writeBuffer = null;
        ByteBufferPool byteBufferPool2 = this.byteBufferPool;
        if (byteBufferPool2 == null) {
            Intrinsics.throwNpe();
        }
        ByteBuffer byteBuffer6 = this.uploadBuffer;
        if (byteBuffer6 == null) {
            Intrinsics.throwNpe();
        }
        byteBufferPool2.free(byteBuffer6);
        this.uploadBuffer = null;
        this.byteBufferPool = null;
    }

    private final void uploadCurrentBufferAndSwitch(boolean isLastPart) {
        int nBytesToUpload;
        ByteBuffer byteBuffer = this.writeBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        if ((nBytesToUpload = byteBuffer.position()) == 0) {
            return;
        }
        if (!isLastPart && nBytesToUpload < 0x500000) {
            StringBuilder stringBuilder = new StringBuilder().append("Cannot upload - minimum upload size is 5242880 bytes, got only ");
            ByteBuffer byteBuffer2 = this.writeBuffer;
            if (byteBuffer2 == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)new IllegalStateException(stringBuilder.append(byteBuffer2.position()).toString());
        }
        this.waitForCurrentUploadToFinish();
        ByteBuffer byteBuffer3 = this.writeBuffer;
        if (byteBuffer3 == null) {
            Intrinsics.throwNpe();
        }
        ByteBuffer bufferToUpload = byteBuffer3;
        ByteBuffer byteBuffer4 = this.writeBuffer = this.uploadBuffer;
        if (byteBuffer4 == null) {
            Intrinsics.throwNpe();
        }
        byteBuffer4.clear();
        this.uploadBuffer = bufferToUpload;
        bufferToUpload.flip();
        this.mostRecentUploadHandle = this.getUploader().queuePart(bufferToUpload);
    }

    static /* bridge */ /* synthetic */ void uploadCurrentBufferAndSwitch$default(S3OutputStream s3OutputStream, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        s3OutputStream.uploadCurrentBufferAndSwitch(bl);
    }

    private final void waitForCurrentUploadToFinish() {
        block0: {
            Future<Unit> future = this.mostRecentUploadHandle;
            if (future == null) break block0;
            future.get();
        }
    }

    @NotNull
    public final AmazonS3 getAwsS3() {
        return this.awsS3;
    }

    @NotNull
    public final String getTargetBucket() {
        return this.targetBucket;
    }

    @NotNull
    public final String getTargetS3Key() {
        return this.targetS3Key;
    }

    public final long getMaxLocalCache() {
        return this.maxLocalCache;
    }

    public final boolean getUseChecksums() {
        return this.useChecksums;
    }

    public S3OutputStream(@NotNull AmazonS3 awsS3, @NotNull String targetBucket, @NotNull String targetS3Key, long maxLocalCache, boolean useChecksums, @NotNull ByteBufferPool byteBufferPool) {
        Intrinsics.checkParameterIsNotNull((Object)awsS3, (String)"awsS3");
        Intrinsics.checkParameterIsNotNull((Object)targetBucket, (String)"targetBucket");
        Intrinsics.checkParameterIsNotNull((Object)targetS3Key, (String)"targetS3Key");
        Intrinsics.checkParameterIsNotNull((Object)byteBufferPool, (String)"byteBufferPool");
        this.awsS3 = awsS3;
        this.targetBucket = targetBucket;
        this.targetS3Key = targetS3Key;
        this.maxLocalCache = maxLocalCache;
        this.useChecksums = useChecksums;
        if (this.maxLocalCache < (long)0xA00000) {
            throw (Throwable)new IllegalArgumentException("The local cache must be at least 10485760 bytes (because single upload parts must be at least 5242880 bytes)");
        }
        this.actualLocalCache = Math.min(0xFFFFFFFEL, Math.min(this.maxLocalCache, 0x280000000L));
        this.byteBufferPool = byteBufferPool;
        this.writeBuffer = byteBufferPool.pop((int)(this.actualLocalCache / 2L));
        this.uploadBuffer = byteBufferPool.pop((int)(this.maxLocalCache / 2L));
        this.uploader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<S3MultipartUploader>(this){
            final /* synthetic */ S3OutputStream this$0;

            @NotNull
            public final S3MultipartUploader invoke() {
                return new S3MultipartUploader(this.this$0.getAwsS3(), this.this$0.getTargetBucket(), this.this$0.getTargetS3Key(), this.this$0.getUseChecksums());
            }
            {
                this.this$0 = s3OutputStream;
                super(0);
            }
        }));
    }

    public /* synthetic */ S3OutputStream(AmazonS3 amazonS3, String string, String string2, long l, boolean bl, ByteBufferPool byteBufferPool, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = Math.max(0x1400000L, 0x3200000L);
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            byteBufferPool = ByteBufferPool.Companion.default();
        }
        this(amazonS3, string, string2, l, bl, byteBufferPool);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/hubject/aws/s3/io/S3OutputStream$Companion;", "", "()V", "MAX_SINGLE_FILE_UPLOAD_SIZE", "", "MAX_UPLOAD_PART_SIZE", "MIN_UPLOAD_PART_SIZE", "", "aws-s3-io"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

