/*
 * Decompiled with CFR 0.152.
 */
package com.hubject.aws.s3.io;

import com.hubject.aws.s3.io.ByteBufferPool;
import com.hubject.aws.s3.io.SimpleByteBufferPool;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u000fj\b\u0012\u0004\u0012\u00020\u000b`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/hubject/aws/s3/io/SimpleByteBufferPool;", "Lcom/hubject/aws/s3/io/ByteBufferPool;", "allocateDirect", "", "maxSpareBuffers", "", "(ZI)V", "getAllocateDirect", "()Z", "allocator", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "getMaxSpareBuffers", "()I", "spareBuffers", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "createBuffer", "minSize", "free", "", "buffer", "pop", "aws-s3-io"})
public final class SimpleByteBufferPool
implements ByteBufferPool {
    private final ArrayList<ByteBuffer> spareBuffers;
    private final Function1<Integer, ByteBuffer> allocator;
    private final boolean allocateDirect;
    private final int maxSpareBuffers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteBuffer pop(int minSize) {
        ArrayList<ByteBuffer> arrayList = this.spareBuffers;
        synchronized (arrayList) {
            ByteBuffer buffer;
            block8: {
                Object v0;
                void $receiver$iv$iv;
                Iterable $receiver$iv = this.spareBuffers;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    ByteBuffer it = (ByteBuffer)element$iv$iv;
                    if (!(it.capacity() >= minSize)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Iterator iterator$iv = $receiver$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    ByteBuffer it = (ByteBuffer)minElem$iv;
                    int minValue$iv = it.capacity();
                    while (iterator$iv.hasNext()) {
                        Object e$iv = iterator$iv.next();
                        ByteBuffer it2 = (ByteBuffer)e$iv;
                        int v$iv = it2.capacity();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    }
                    v0 = minElem$iv;
                }
                buffer = v0;
                if (buffer != null) break block8;
                ByteBuffer byteBuffer = this.createBuffer(minSize);
                return byteBuffer;
            }
            this.spareBuffers.remove(buffer);
            buffer.clear();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(@NotNull ByteBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        ArrayList<ByteBuffer> arrayList = this.spareBuffers;
        synchronized (arrayList) {
            if (this.spareBuffers.size() < this.maxSpareBuffers) {
                buffer.clear();
                this.spareBuffers.add(buffer);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final ByteBuffer createBuffer(int minSize) {
        int n;
        if (minSize % 1024 == 0) {
            n = minSize;
        } else {
            int factor = (int)Math.ceil((double)minSize / 1024.0);
            if (factor == 0) {
                factor = 1;
            }
            n = factor * 1024;
        }
        int targetSize = n;
        return (ByteBuffer)this.allocator.invoke((Object)targetSize);
    }

    public final boolean getAllocateDirect() {
        return this.allocateDirect;
    }

    public final int getMaxSpareBuffers() {
        return this.maxSpareBuffers;
    }

    @JvmOverloads
    public SimpleByteBufferPool(boolean allocateDirect, int maxSpareBuffers) {
        this.allocateDirect = allocateDirect;
        this.maxSpareBuffers = maxSpareBuffers;
        this.spareBuffers = new ArrayList();
        this.allocator = this.allocateDirect ? (Function1)allocator.1.INSTANCE : (Function1)allocator.2.INSTANCE;
    }

    @JvmOverloads
    public /* synthetic */ SimpleByteBufferPool(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = true;
        }
        if ((n2 & 2) != 0) {
            n = 2;
        }
        this(bl, n);
    }

    @JvmOverloads
    public SimpleByteBufferPool(boolean allocateDirect) {
        this(allocateDirect, 0, 2, null);
    }

    @JvmOverloads
    public SimpleByteBufferPool() {
        this(false, 0, 3, null);
    }
}

