/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.io.BaseEncoding;
import com.hubspot.baragon.models.AgentRequestType;

public class AgentRequestId {
    private final AgentRequestType type;
    private final String baseUrl;

    public static AgentRequestId fromString(String value) {
        String[] splits = value.split("\\-", 2);
        return new AgentRequestId(AgentRequestType.valueOf(splits[0]), new String(BaseEncoding.base64Url().decode((CharSequence)splits[1]), Charsets.UTF_8));
    }

    private AgentRequestId(AgentRequestType type, String baseUrl) {
        this.type = type;
        this.baseUrl = baseUrl;
    }

    public AgentRequestType getType() {
        return this.type;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentRequestId that = (AgentRequestId)o;
        if (!this.baseUrl.equals(that.baseUrl)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.baseUrl.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("baseUrl", (Object)this.baseUrl).toString();
    }
}

