/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.baragon.models.AgentRequestsStatus;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AgentResponse {
    private final String url;
    private final int attempt;
    private final Optional<Integer> statusCode;
    private final Optional<String> content;
    private final Optional<String> exception;

    @JsonCreator
    public AgentResponse(@JsonProperty(value="url") String url, @JsonProperty(value="attempt") int attempt, @JsonProperty(value="statusCode") Optional<Integer> statusCode, @JsonProperty(value="content") Optional<String> content, @JsonProperty(value="exception") Optional<String> exception) {
        this.url = url;
        this.attempt = attempt;
        this.statusCode = statusCode;
        this.content = content;
        this.exception = exception;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<Integer> getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getContent() {
        return this.content;
    }

    public Optional<String> getException() {
        return this.exception;
    }

    @JsonIgnore
    public AgentRequestsStatus toRequestStatus() {
        if (!this.statusCode.isPresent() && !this.exception.isPresent()) {
            return AgentRequestsStatus.WAITING;
        }
        if (this.statusCode.isPresent() && (Integer)this.statusCode.get() >= 200 && (Integer)this.statusCode.get() < 300) {
            return AgentRequestsStatus.SUCCESS;
        }
        return AgentRequestsStatus.FAILURE;
    }

    public String toString() {
        return "AgentResponse [url='" + this.url + '\'' + ", attempt=" + this.attempt + ", statusCode=" + this.statusCode + ", content=" + this.content + ", exception=" + this.exception + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentResponse that = (AgentResponse)o;
        if (this.attempt != that.attempt) {
            return false;
        }
        if (!this.content.equals(that.content)) {
            return false;
        }
        if (!this.exception.equals(that.exception)) {
            return false;
        }
        if (!this.statusCode.equals(that.statusCode)) {
            return false;
        }
        return this.url.equals(that.url);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.attempt;
        result = 31 * result + this.statusCode.hashCode();
        result = 31 * result + this.content.hashCode();
        result = 31 * result + this.exception.hashCode();
        return result;
    }
}

