/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.amazonaws.util.EC2MetadataUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonAgentEc2Metadata {
    private final Optional<String> instanceId;
    private final Optional<String> availabilityZone;
    private final Optional<String> subnetId;

    @JsonCreator
    public BaragonAgentEc2Metadata(@JsonProperty(value="instanceId") Optional<String> instanceId, @JsonProperty(value="availabilityZone") Optional<String> availabilityZone, @JsonProperty(value="subnetId") Optional<String> subnetId) {
        this.instanceId = instanceId;
        this.availabilityZone = availabilityZone;
        this.subnetId = subnetId;
    }

    public static BaragonAgentEc2Metadata fromEnvironment() {
        return new BaragonAgentEc2Metadata(BaragonAgentEc2Metadata.findInstanceId(), BaragonAgentEc2Metadata.findAvailabilityZone(), BaragonAgentEc2Metadata.findSubnet());
    }

    public static Optional<String> findInstanceId() {
        try {
            return Optional.fromNullable((Object)EC2MetadataUtils.getInstanceId());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public static Optional<String> findAvailabilityZone() {
        try {
            return Optional.fromNullable((Object)EC2MetadataUtils.getAvailabilityZone());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    private static Optional<String> findSubnet() {
        try {
            List networkInterfaces = EC2MetadataUtils.getNetworkInterfaces();
            if (EC2MetadataUtils.getNetworkInterfaces().isEmpty()) {
                return Optional.absent();
            }
            return Optional.fromNullable((Object)((EC2MetadataUtils.NetworkInterface)networkInterfaces.get(0)).getSubnetId());
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public Optional<String> getInstanceId() {
        return this.instanceId;
    }

    public Optional<String> getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Optional<String> getSubnetId() {
        return this.subnetId;
    }
}

