/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.hubspot.baragon.exceptions.InvalidAgentMetadataStringException;
import com.hubspot.baragon.models.BaragonAgentEc2Metadata;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonAgentMetadata {
    public static final Pattern AGENT_METADATA_STRING_REGEX = Pattern.compile("^http[s]?:\\/\\/([^:\\/]+:\\d{1,5})\\/.*$");
    private final String baseAgentUri;
    private final Optional<String> domain;
    private final String agentId;
    private final BaragonAgentEc2Metadata ec2;

    @JsonCreator
    public static BaragonAgentMetadata fromString(String value) {
        Matcher matcher = AGENT_METADATA_STRING_REGEX.matcher(value);
        if (!matcher.matches()) {
            throw new InvalidAgentMetadataStringException(value);
        }
        return new BaragonAgentMetadata(value, matcher.group(1), (Optional<String>)Optional.absent(), new BaragonAgentEc2Metadata((Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent()));
    }

    @JsonCreator
    public BaragonAgentMetadata(@JsonProperty(value="baseAgentUri") String baseAgentUri, @JsonProperty(value="agentId") String agentId, @JsonProperty(value="domain") Optional<String> domain, @JsonProperty(value="ec2") BaragonAgentEc2Metadata ec2) {
        this.baseAgentUri = baseAgentUri;
        this.domain = domain;
        this.agentId = agentId;
        this.ec2 = ec2;
    }

    public String getBaseAgentUri() {
        return this.baseAgentUri;
    }

    public Optional<String> getDomain() {
        return this.domain;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public BaragonAgentEc2Metadata getEc2() {
        return this.ec2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonAgentMetadata metadata = (BaragonAgentMetadata)o;
        if (this.agentId != null ? !this.agentId.equals(metadata.agentId) : metadata.agentId != null) {
            return false;
        }
        if (!this.baseAgentUri.equals(metadata.baseAgentUri)) {
            return false;
        }
        if (!this.domain.equals(metadata.domain)) {
            return false;
        }
        return this.ec2.equals(metadata.ec2);
    }

    public int hashCode() {
        int result = this.baseAgentUri.hashCode();
        result = 31 * result + this.domain.hashCode();
        result = 31 * result + (this.agentId != null ? this.agentId.hashCode() : 0);
        result = 31 * result + (this.ec2 != null ? this.ec2.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("baseAgentUri", (Object)this.baseAgentUri).add("domain", this.domain).add("agentId", (Object)this.agentId).add("ec2", (Object)this.ec2).toString();
    }
}

