/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonAuthKey {
    private final String value;
    private final String owner;
    private final long createdAt;
    private final Optional<Long> expiredAt;

    public static BaragonAuthKey expire(BaragonAuthKey authKey) {
        return new BaragonAuthKey(authKey.getValue(), authKey.getOwner(), authKey.getCreatedAt(), (Optional<Long>)Optional.of((Object)System.currentTimeMillis()));
    }

    @JsonCreator
    public BaragonAuthKey(@JsonProperty(value="value") String value, @JsonProperty(value="owner") String owner, @JsonProperty(value="createdAt") long createdAt, @JsonProperty(value="expiredAt") Optional<Long> expiredAt) {
        this.value = value;
        this.owner = owner;
        this.createdAt = createdAt;
        this.expiredAt = expiredAt;
    }

    public String getValue() {
        return this.value;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Optional<Long> getExpiredAt() {
        return this.expiredAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonAuthKey that = (BaragonAuthKey)o;
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (!this.expiredAt.equals(that.expiredAt)) {
            return false;
        }
        if (!this.owner.equals(that.owner)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.owner.hashCode();
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + this.expiredAt.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("owner", (Object)this.owner).add("createdAt", this.createdAt).add("expiredAt", this.expiredAt).toString();
    }
}

