/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.hubspot.baragon.models.AgentResponse;
import com.hubspot.baragon.models.BaragonRequest;
import com.hubspot.baragon.models.BaragonRequestState;
import java.util.Collection;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonResponse {
    private final String loadBalancerRequestId;
    private final BaragonRequestState loadBalancerState;
    private final Optional<String> message;
    private final Optional<Map<String, Collection<AgentResponse>>> agentResponses;
    private final Optional<BaragonRequest> request;
    private final boolean postApplyStepsSucceeded;

    public static BaragonResponse failure(String requestId, String message) {
        return new BaragonResponse(requestId, BaragonRequestState.FAILED, (Optional<String>)Optional.fromNullable((Object)message), (Optional<Map<String, Collection<AgentResponse>>>)Optional.absent(), (Optional<BaragonRequest>)Optional.absent(), false);
    }

    public static BaragonResponse requestDoesNotExist(String requestId) {
        return new BaragonResponse(requestId, BaragonRequestState.CANCELED, (Optional<String>)Optional.of((Object)String.format("Request %s does not exist", requestId)), (Optional<Map<String, Collection<AgentResponse>>>)Optional.absent(), (Optional<BaragonRequest>)Optional.absent(), false);
    }

    public static BaragonResponse serviceNotFound(String requestId, String serviceId) {
        return new BaragonResponse(requestId, BaragonRequestState.INVALID_REQUEST_NOOP, (Optional<String>)Optional.of((Object)String.format("Service %s not found", serviceId)), (Optional<Map<String, Collection<AgentResponse>>>)Optional.absent(), (Optional<BaragonRequest>)Optional.absent(), false);
    }

    @JsonCreator
    public BaragonResponse(@JsonProperty(value="loadBalancerRequestId") String loadBalancerRequestId, @JsonProperty(value="loadBalancerState") BaragonRequestState loadBalancerState, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="agentResponses") Optional<Map<String, Collection<AgentResponse>>> agentResponses, @JsonProperty(value="request") Optional<BaragonRequest> request, @JsonProperty(value="postApplyStepsSucceeded") Boolean postApplyStepsSucceeded) {
        this.loadBalancerRequestId = loadBalancerRequestId;
        this.loadBalancerState = loadBalancerState;
        this.message = message;
        this.agentResponses = agentResponses;
        this.request = request;
        this.postApplyStepsSucceeded = (Boolean)MoreObjects.firstNonNull((Object)postApplyStepsSucceeded, (Object)(loadBalancerState == BaragonRequestState.SUCCESS ? 1 : 0));
    }

    public String getLoadBalancerRequestId() {
        return this.loadBalancerRequestId;
    }

    public BaragonRequestState getLoadBalancerState() {
        return this.loadBalancerState;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public Optional<Map<String, Collection<AgentResponse>>> getAgentResponses() {
        return this.agentResponses;
    }

    public Optional<BaragonRequest> getRequest() {
        return this.request;
    }

    public String toString() {
        return "BaragonResponse{loadBalancerRequestId='" + this.loadBalancerRequestId + '\'' + ", loadBalancerState=" + (Object)((Object)this.loadBalancerState) + ", message=" + this.message + ", agentResponses=" + this.agentResponses + ", request=" + this.request + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonResponse that = (BaragonResponse)o;
        if (!this.agentResponses.equals(that.agentResponses)) {
            return false;
        }
        if (!this.loadBalancerRequestId.equals(that.loadBalancerRequestId)) {
            return false;
        }
        if (this.loadBalancerState != that.loadBalancerState) {
            return false;
        }
        if (!this.message.equals(that.message)) {
            return false;
        }
        return this.request.equals(that.request);
    }

    public int hashCode() {
        int result = this.loadBalancerRequestId.hashCode();
        result = 31 * result + this.loadBalancerState.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.agentResponses.hashCode();
        result = 31 * result + this.request.hashCode();
        return result;
    }
}

