/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.hubspot.baragon.models.BaragonService;
import com.hubspot.baragon.models.UpstreamInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ServiceContext {
    private final BaragonService service;
    private final Collection<UpstreamInfo> upstreams;
    private final Map<String, Collection<UpstreamInfo>> upstreamGroups;
    private final Long timestamp;
    private final boolean present;
    private final boolean rootPath;

    @JsonCreator
    public ServiceContext(@JsonProperty(value="service") BaragonService service, @JsonProperty(value="upstreams") Collection<UpstreamInfo> upstreams, @JsonProperty(value="timestamp") Long timestamp, @JsonProperty(value="present") boolean present) {
        this.service = service;
        this.timestamp = timestamp;
        this.upstreams = (Collection)MoreObjects.firstNonNull(upstreams, Collections.emptyList());
        this.present = present;
        this.rootPath = service.getServiceBasePath().equals("/");
        if (!this.upstreams.isEmpty()) {
            ArrayListMultimap upstreamGroupsMultimap = ArrayListMultimap.create();
            for (UpstreamInfo upstream : this.upstreams) {
                upstreamGroupsMultimap.put((Object)upstream.getGroup(), (Object)upstream);
            }
            this.upstreamGroups = upstreamGroupsMultimap.asMap();
        } else {
            this.upstreamGroups = Collections.emptyMap();
        }
    }

    public BaragonService getService() {
        return this.service;
    }

    public Collection<UpstreamInfo> getUpstreams() {
        return this.upstreams;
    }

    public Map<String, Collection<UpstreamInfo>> getUpstreamGroups() {
        return this.upstreamGroups;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isRootPath() {
        return this.rootPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceContext that = (ServiceContext)o;
        if (this.present != that.present) {
            return false;
        }
        if (!this.service.equals(that.service)) {
            return false;
        }
        if (!this.timestamp.equals(that.timestamp)) {
            return false;
        }
        if (!this.upstreams.equals(that.upstreams)) {
            return false;
        }
        return this.rootPath == that.rootPath;
    }

    public int hashCode() {
        int result = this.service.hashCode();
        result = 31 * result + this.upstreams.hashCode();
        result = 31 * result + this.timestamp.hashCode();
        result = 31 * result + (this.present ? 1 : 0);
        result = 31 * result + (this.rootPath ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ServiceContext [service=" + this.service + ", upstreams=" + this.upstreams + ", timestamp=" + this.timestamp + ", present=" + this.present + ", rootPath=" + this.rootPath + ']';
    }
}

