/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.ning;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.hubspot.horizon.AsyncHttpClient;
import com.hubspot.horizon.HttpConfig;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.horizon.ning.internal.AcceptEncodingRequestFilter;
import com.hubspot.horizon.ning.internal.EmptyCallback;
import com.hubspot.horizon.ning.internal.NingCompletionHandler;
import com.hubspot.horizon.ning.internal.NingFuture;
import com.hubspot.horizon.ning.internal.NingHostnameVerifier;
import com.hubspot.horizon.ning.internal.NingHttpRequestConverter;
import com.hubspot.horizon.ning.internal.NingRetryHandler;
import com.hubspot.horizon.ning.internal.NingSSLContext;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.extra.ThrottleRequestFilter;
import com.ning.http.client.filter.RequestFilter;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;

public class NingAsyncHttpClient
implements AsyncHttpClient {
    private final com.ning.http.client.AsyncHttpClient ningClient;
    private final NingHttpRequestConverter requestConverter;
    private final HttpRequest.Options defaultOptions;
    private final ObjectMapper mapper;

    public NingAsyncHttpClient() {
        this(HttpConfig.newBuilder().build());
    }

    public NingAsyncHttpClient(HttpConfig config) {
        Preconditions.checkNotNull((Object)config);
        AsyncHttpClientConfig ningConfig = new AsyncHttpClientConfig.Builder().addRequestFilter((RequestFilter)new ThrottleRequestFilter(config.getMaxConnections())).addRequestFilter((RequestFilter)new AcceptEncodingRequestFilter()).setMaximumConnectionsPerHost(config.getMaxConnectionsPerHost()).setConnectionTimeoutInMs(config.getConnectTimeoutMillis()).setRequestTimeoutInMs(config.getRequestTimeoutMillis()).setMaximumNumberOfRedirects(config.getMaxRedirects()).setFollowRedirects(config.isFollowRedirects()).setHostnameVerifier((HostnameVerifier)new NingHostnameVerifier(config.getSSLConfig())).setSSLContext(NingSSLContext.forConfig(config.getSSLConfig())).setUserAgent(config.getUserAgent()).setCompressionEnabled(true).setIOThreadMultiplier(1).build();
        this.ningClient = new com.ning.http.client.AsyncHttpClient(ningConfig);
        this.requestConverter = new NingHttpRequestConverter(config.getObjectMapper());
        this.defaultOptions = config.getOptions();
        this.mapper = config.getObjectMapper();
    }

    public ListenableFuture<HttpResponse> execute(HttpRequest request) {
        return this.execute((HttpRequest)Preconditions.checkNotNull((Object)request), HttpRequest.Options.DEFAULT);
    }

    public ListenableFuture<HttpResponse> execute(HttpRequest request, HttpRequest.Options options) {
        return this.internalExecute(request, options, EmptyCallback.INSTANCE);
    }

    public void execute(HttpRequest request, AsyncHttpClient.Callback callback) {
        this.execute((HttpRequest)Preconditions.checkNotNull((Object)request), HttpRequest.Options.DEFAULT, callback);
    }

    public void execute(HttpRequest request, HttpRequest.Options options, AsyncHttpClient.Callback callback) {
        this.internalExecute(request, options, callback);
    }

    private ListenableFuture<HttpResponse> internalExecute(HttpRequest request, HttpRequest.Options options, AsyncHttpClient.Callback callback) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)callback);
        NingRetryHandler retryHandler = new NingRetryHandler(this.defaultOptions.mergeFrom(options));
        NingFuture future = new NingFuture(callback);
        final NingCompletionHandler completionHandler = new NingCompletionHandler(request, future, retryHandler, this.mapper);
        final Request ningRequest = this.requestConverter.convert(request);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    NingAsyncHttpClient.this.ningClient.executeRequest(ningRequest, (AsyncHandler)completionHandler);
                }
                catch (Exception e) {
                    completionHandler.onThrowable(e);
                }
            }
        };
        retryHandler.setRetryRunnable(runnable);
        runnable.run();
        return future;
    }

    public void close() throws IOException {
        this.ningClient.close();
    }
}

