/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.ning.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.horizon.internal.AbstractHttpResponse;
import com.hubspot.horizon.ning.internal.NingFuture;
import com.hubspot.horizon.ning.internal.NingHttpResponse;
import com.hubspot.horizon.ning.internal.NingRetryHandler;
import com.hubspot.horizon.ning.internal.SnappyHttpResponseWrapper;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import java.io.IOException;

public class NingCompletionHandler
extends AsyncCompletionHandler<HttpResponse> {
    private final HttpRequest request;
    private final NingFuture future;
    private final NingRetryHandler retryHandler;
    private final ObjectMapper mapper;

    public NingCompletionHandler(HttpRequest request, NingFuture future, NingRetryHandler retryHandler, ObjectMapper mapper) {
        this.request = request;
        this.future = future;
        this.retryHandler = retryHandler;
        this.mapper = mapper;
    }

    public HttpResponse onCompleted(Response ningResponse) throws Exception {
        AbstractHttpResponse response = new NingHttpResponse(this.request, ningResponse, this.mapper);
        if ("snappy".equals(ningResponse.getHeader("Content-Encoding"))) {
            response = new SnappyHttpResponseWrapper(response);
        }
        if (this.retryHandler.shouldRetry(this.request, (HttpResponse)response)) {
            this.retryHandler.retry();
        } else {
            this.future.setNonnull((HttpResponse)response);
        }
        return response;
    }

    public void onThrowable(Throwable t) {
        IOException e;
        IOException iOException = e = t instanceof IOException ? (IOException)t : new IOException(t);
        if (this.retryHandler.shouldRetry(this.request, e)) {
            this.retryHandler.retry();
        } else {
            this.future.setException(e);
        }
    }
}

