/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.ning.internal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.hubspot.horizon.AsyncHttpClient;
import com.hubspot.horizon.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NingFuture
extends AbstractFuture<HttpResponse> {
    private final AsyncHttpClient.Callback callback;

    public NingFuture(AsyncHttpClient.Callback callback) {
        this.callback = new CallbackWrapper((AsyncHttpClient.Callback)Preconditions.checkNotNull((Object)callback));
    }

    public boolean setNonnull(HttpResponse response) {
        Preconditions.checkNotNull((Object)response);
        if (this.set(response)) {
            this.callback.completed(response);
            return true;
        }
        return false;
    }

    public boolean setException(Throwable t) {
        Preconditions.checkNotNull((Object)t);
        if (super.setException(t)) {
            this.callback.failed(t instanceof Exception ? (Exception)t : new Exception(t));
            return true;
        }
        return false;
    }

    private static final class CallbackWrapper
    implements AsyncHttpClient.Callback {
        private static final Logger LOG = LoggerFactory.getLogger(CallbackWrapper.class);
        private final AsyncHttpClient.Callback callback;

        private CallbackWrapper(AsyncHttpClient.Callback callback) {
            this.callback = (AsyncHttpClient.Callback)Preconditions.checkNotNull((Object)callback);
        }

        public void completed(HttpResponse response) {
            try {
                this.callback.completed(response);
            }
            catch (Exception e) {
                LOG.error("Exception in callback", (Throwable)e);
            }
        }

        public void failed(Exception e) {
            try {
                this.callback.failed(e);
            }
            catch (Exception f) {
                LOG.error("Exception in callback", (Throwable)f);
            }
        }
    }
}

