/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.ning;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.horizon.AsyncHttpClient;
import com.hubspot.horizon.HttpConfig;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.horizon.ning.internal.AcceptEncodingRequestFilter;
import com.hubspot.horizon.ning.internal.EmptyCallback;
import com.hubspot.horizon.ning.internal.NingCompletionHandler;
import com.hubspot.horizon.ning.internal.NingFuture;
import com.hubspot.horizon.ning.internal.NingHostnameVerifier;
import com.hubspot.horizon.ning.internal.NingHttpRequestConverter;
import com.hubspot.horizon.ning.internal.NingRetryHandler;
import com.hubspot.horizon.ning.internal.NingSSLContext;
import com.hubspot.horizon.shaded.com.ning.http.client.AsyncHttpClientConfig;
import com.hubspot.horizon.shaded.com.ning.http.client.AsyncHttpProviderConfig;
import com.hubspot.horizon.shaded.com.ning.http.client.Request;
import com.hubspot.horizon.shaded.com.ning.http.client.extra.ThrottleRequestFilter;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.socket.nio.NioClientBossPool;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import com.hubspot.horizon.shaded.org.jboss.netty.channel.socket.nio.NioWorkerPool;
import com.hubspot.horizon.shaded.org.jboss.netty.util.HashedWheelTimer;
import com.hubspot.horizon.shaded.org.jboss.netty.util.ThreadNameDeterminer;
import com.hubspot.horizon.shaded.org.jboss.netty.util.ThreadRenamingRunnable;
import com.hubspot.horizon.shaded.org.jboss.netty.util.Timer;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class NingAsyncHttpClient
implements AsyncHttpClient {
    private static final ExecutorService BOSS_EXECUTOR = NingAsyncHttpClient.newExecutor("NioBoss");
    private final com.hubspot.horizon.shaded.com.ning.http.client.AsyncHttpClient ningClient;
    private final NingHttpRequestConverter requestConverter;
    private final HttpRequest.Options defaultOptions;
    private final ObjectMapper mapper;

    public NingAsyncHttpClient() {
        this(HttpConfig.newBuilder().build());
    }

    public NingAsyncHttpClient(HttpConfig config) {
        Preconditions.checkNotNull((Object)config);
        AsyncHttpClientConfig ningConfig = new AsyncHttpClientConfig.Builder().addRequestFilter(new ThrottleRequestFilter(config.getMaxConnections())).addRequestFilter(new AcceptEncodingRequestFilter()).setMaximumConnectionsPerHost(config.getMaxConnectionsPerHost()).setConnectionTimeoutInMs(config.getConnectTimeoutMillis()).setRequestTimeoutInMs(config.getRequestTimeoutMillis()).setMaximumNumberOfRedirects(config.getMaxRedirects()).setFollowRedirects(config.isFollowRedirects()).setHostnameVerifier(new NingHostnameVerifier(config.getSSLConfig())).setSSLContext(NingSSLContext.forConfig(config.getSSLConfig())).setAsyncHttpClientProviderConfig(NingAsyncHttpClient.newAsyncProviderConfig()).setUserAgent(config.getUserAgent()).setCompressionEnabled(true).setIOThreadMultiplier(1).build();
        this.ningClient = new com.hubspot.horizon.shaded.com.ning.http.client.AsyncHttpClient(ningConfig);
        this.requestConverter = new NingHttpRequestConverter(config.getObjectMapper());
        this.defaultOptions = config.getOptions();
        this.mapper = config.getObjectMapper();
    }

    public ListenableFuture<HttpResponse> execute(HttpRequest request) {
        return this.execute((HttpRequest)Preconditions.checkNotNull((Object)request), HttpRequest.Options.DEFAULT);
    }

    public ListenableFuture<HttpResponse> execute(HttpRequest request, HttpRequest.Options options) {
        return this.internalExecute(request, options, EmptyCallback.INSTANCE);
    }

    public void execute(HttpRequest request, AsyncHttpClient.Callback callback) {
        this.execute((HttpRequest)Preconditions.checkNotNull((Object)request), HttpRequest.Options.DEFAULT, callback);
    }

    public void execute(HttpRequest request, HttpRequest.Options options, AsyncHttpClient.Callback callback) {
        this.internalExecute(request, options, callback);
    }

    private ListenableFuture<HttpResponse> internalExecute(HttpRequest request, HttpRequest.Options options, AsyncHttpClient.Callback callback) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)callback);
        NingRetryHandler retryHandler = new NingRetryHandler(this.defaultOptions.mergeFrom(options));
        NingFuture future = new NingFuture(callback);
        final NingCompletionHandler completionHandler = new NingCompletionHandler(request, future, retryHandler, this.mapper);
        final Request ningRequest = this.requestConverter.convert(request);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    NingAsyncHttpClient.this.ningClient.executeRequest(ningRequest, completionHandler);
                }
                catch (Exception e) {
                    completionHandler.onThrowable(e);
                }
            }
        };
        retryHandler.setRetryRunnable(runnable);
        runnable.run();
        return future;
    }

    private static AsyncHttpProviderConfig<?, ?> newAsyncProviderConfig() {
        NettyAsyncHttpProviderConfig nettyConfig = new NettyAsyncHttpProviderConfig();
        nettyConfig.addProperty("socketChannelFactory", (Object)NingAsyncHttpClient.newSocketChannelFactory());
        nettyConfig.setNettyTimer(NingAsyncHttpClient.newTimer());
        return nettyConfig;
    }

    private static NioClientSocketChannelFactory newSocketChannelFactory() {
        NioClientBossPool bossPool = new NioClientBossPool(BOSS_EXECUTOR, 1, NingAsyncHttpClient.newTimer(), ThreadNameDeterminer.CURRENT);
        NioWorkerPool workerPool = new NioWorkerPool((Executor)NingAsyncHttpClient.newExecutor("NioWorker"), 5, ThreadNameDeterminer.CURRENT);
        return new NioClientSocketChannelFactory(bossPool, workerPool);
    }

    private static ExecutorService newExecutor(String qualifier) {
        return Executors.newCachedThreadPool(NingAsyncHttpClient.newThreadFactory(qualifier));
    }

    private static Timer newTimer() {
        return new HashedWheelTimer(NingAsyncHttpClient.newThreadFactory("HashedWheelTimer"));
    }

    private static ThreadFactory newThreadFactory(String qualifier) {
        String nameFormat = "NingAsyncHttpClient-" + qualifier + "-%d";
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).build();
    }

    public void close() throws IOException {
        this.ningClient.close();
    }

    static {
        ThreadRenamingRunnable.setThreadNameDeterminer(ThreadNameDeterminer.CURRENT);
    }
}

